% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{AlignSubspace}
\alias{AlignSubspace}
\title{Align subspaces using dynamic time warping (DTW)}
\usage{
AlignSubspace(object, reduction.type = "cca", grouping.var, dims.align,
  num.possible.genes = 2000, num.genes = 30, show.plots = FALSE,
  verbose = TRUE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{Reduction to align scores for. Default is "cca".}

\item{grouping.var}{Name of the grouping variable for which to align the scores}

\item{dims.align}{Dims to align, default is all}

\item{num.possible.genes}{Number of possible genes to search when choosing
genes for the metagene. Set to 2000 by default. Lowering will decrease runtime
but may result in metagenes constructed on fewer than num.genes genes.}

\item{num.genes}{Number of genes to use in construction of "metagene" (default
is 30).}

\item{show.plots}{Show debugging plots}

\item{verbose}{Displays progress and other output}

\item{...}{Additional parameters to ScaleData}
}
\value{
Returns Seurat object with the dims aligned, stored in
 object@dr$reduction.type.aligned
}
\description{
Aligns subspaces across a given grouping variable.
}
\details{
Following is a description for the two group case but this can be extended to
arbitrarily many groups which works by performing pairwise alignment to a
reference group (the largest group). First, we identify genes that are driving
variation in both datasets by looking at the correlation of gene expression
with each projection vector (e.g. CC1) in both datasets. For this we use the
biweight midcorrelation (bicor) and choose the top num.genes with the strongest
bicor to construct a 'metagene' for each dataset. We then scale each metagene
to match its 95\% reference range and linearly shift them by the minimum
difference between the two metagenes over the 10-90 quantile range. We then
map each cell in the smaller dataset to a cell in the larger dataset using
dynamic time warping (DTW) and apply the same map to the projection vectors (
CC vectors) to place both datasets on a common aligned scale. We apply this
procedue to each pair (group) of vectors individually for all specified in
dims.align. For a full description of the method, see Butler et al 2017.
}
\examples{
\dontrun{
pbmc_small
# Requires CCA to have previously been run
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:40])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[41:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc_cca <- RunCCA(pbmc1,pbmc2)
pbmc_cca <- AlignSubspace(pbmc_cca,reduction.type = "cca", grouping.var = "group", dims.align = 1:2)
}

}
