% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell.check.dictionary.R
\name{spell.check.dictionary}
\alias{spell.check.dictionary}
\title{Spelling-check using \link{SemNetDictionaries}}
\usage{
spell.check.dictionary(check, dictionary, part.resp, tolerance = 1)
}
\arguments{
\item{check}{Character vector.
A vector of unique responses from text data}

\item{dictionary}{Character vector.
See \code{\link{SemNetDictionaries}}}

\item{part.resp}{Matrix or data frame.
Uncleaned participant response matrix}

\item{tolerance}{Numeric.
The distance tolerance set for automatic spell-correction purposes.
This function uses the function \code{\link[stringdist]{stringdist}}
to compute the \href{https://en.wikipedia.org/wiki/Damerau-Levenshtein_distance}{Damerau-Levenshtein}
(DL) distance, which is used to determine potential best guesses.

Unique words (i.e., \emph{n} = 1) that are within the (distance) tolerance are
automatically output as best guess responses, which are then passed through
\code{\link[SemNetCleaner]{word.check.wrapper}}. If there is more than one word
that is within or below the distance tolerance, then these will be provided as potential
options.

The recommended and default distance tolerance is \code{tolerance = 1},
which only spell corrects a word if there is only one word with a DL distance of 1.}
}
\value{
Returns a list containing:

\item{from}{A list of all responses before they were cleaned}

\item{to}{A list of all responses after they were cleaned}

\item{dict}{The updated dictionary vector}

\item{from.inc}{A list of only incorrect responses before they were cleaned}

\item{to.inc}{A list of only incorrect responses after they were cleaned}
}
\description{
A wrapper function for spell-checking text dictionaries in \code{\link{SemNetDictionaries}}
(combines all spell-checking wrapper functions)
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

if(interactive())
{
    scd <- spell.check.dictionary(check = unique(unlist(raw)),
    dictionary = SemNetDictionaries::animals.dictionary,
    part.resp = raw) 
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
