% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.bootSemNeT.R
\name{test.bootSemNeT}
\alias{test.bootSemNeT}
\title{Statistical tests for \code{\link[SemNeT]{bootSemNeT}}}
\usage{
test.bootSemNeT(
  ...,
  test = c("ANCOVA", "ANOVA", "t-test"),
  measures = c("ASPL", "CC", "Q"),
  formula = NULL,
  groups = NULL
)
}
\arguments{
\item{...}{Object(s) from \code{\link[SemNeT]{bootSemNeT}}}

\item{test}{Character.
Type of statistical test to be used.

\itemize{

\item{\code{"t-test"}}
{Computes t-tests for all measures}

\item{\code{"ANOVA"}}
{Computes ANOVAs and includes
Tukey's HSD for pairwise comparisons (\code{\link{TukeyHSD}})}

\item{\code{"ANCOVA"}}
{Computes ANCOVAs that control for the number of nodes
and edges in the networks and includes adjusted means
and Tukey's HSD for pairwise comparisons (\code{\link{TukeyHSD}})}}}

\item{measures}{Character.
Network measures to be tested.

\itemize{

\item{\code{\link[SemNeT]{ASPL}}}
{Average shortest path length}

\item{\code{\link[SemNeT]{CC}}}
{Clustering coefficient}

\item{\code{\link[SemNeT]{Q}}}
{Modularity statistic}

}}

\item{formula}{Character.
A formula for specifying an ANOVA structure. The formula should
have the predictor variable as "y" and include the names the variables
are grouped by (e.g., \code{formula = "y ~ group_var1 * group_var2"}).
See Two-way ANOVA example in examples}

\item{groups}{Data frame.
A data frame specifying the groups to be input into the formula.
The column names should be the variable names of interest. The
groups should be in the same order as the groups input into
\code{\link[SemNeT]{bootSemNeT}}}
}
\value{
Returns a list containing the objects:

\item{ASPL}{Test statistics for each proportion of nodes remaining for ASPL}

\item{CC}{Test statistics for each proportion of nodes remaining for CC}

\item{Q}{Test statistics for each proportion of nodes remaining for Q}

If two groups:

A matrix in each object has the following columns:

\item{t-statistic}{Statistic from the \code{\link{t.test}}}

\item{df}{Degrees of freedom}

\item{p-value}{\emph{p}-value with values equal to \code{0} being \emph{p} < .001}

\item{d}{Cohen's \emph{d}}

\item{CI95.lower}{Lower bound of the 95 percent confidence interval}

\item{CI95.upper}{Upper bound of the 95 percent confidence interval}

\item{Direction}{Direction of the effect. The argument \code{groups} will
specify specifically which group is higher or lower on the measure. If no
groups are input, then \code{"d"} and \code{"p"} are used to represent
\code{data} and \code{paired} samples from \code{\link[SemNeT]{bootSemNeT}}, respectively}

Row names refer to the proportion of nodes remaining in bootstrapped networks

If three or more groups:

A list containing two objects:

\item{ANOVA}{A matrix containing the \emph{F}-statistic, group degrees of freedom,
residual degrees of freedom, \emph{p}-value, and partial eta squared {\code{p.eta.sq}}}

\item{HSD}{A matrix containing the differences between each group (\code{diff}),
lower (\code{lwr}) and upper (\code{upr}) bounds of the 95\% confidence interval,
and the adjusted \emph{p}-value (\code{p.adj})}
}
\description{
Computes statistical tests for bootstrapped
networks from \code{\link[SemNeT]{bootSemNeT}}
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
two <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
two.result <- bootSemNeT(one, two, prop = .50, iter = 100,
sim = "cosine", cores = 2, type = "node", method = "TMFG")
}
# Compute tests
test.bootSemNeT(two.result)

\donttest{
# Two-way ANOVA example
## Simulated data
hihi <- sim.fluency(50, 500)
hilo <- sim.fluency(50, 500)
lohi <- sim.fluency(50, 500)
lolo <- sim.fluency(50, 500)

## Create groups
groups <- matrix(
c("high", "high",
"high", "low",
"low", "high",
"low", "low"
), ncol = 2, byrow = TRUE)

## Change column names (variable names)
colnames(groups) <- c("gf","caq")

## Run partial bootstrap networks
boot.fifty <- bootSemNeT(hihi, hilo, lohi, lolo, prop = .50,
type = "node", method = "TMFG", cores = 2, iter = 100)
boot.sixty <- bootSemNeT(hihi, hilo, lohi, lolo, prop = .60,
type = "node", method = "TMFG", cores = 2, iter = 100)

## Compute tests
test.bootSemNeT(boot.fifty, boot.sixty,
test = "ANOVA", formula = "y ~ gf*caq", groups = groups)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
