% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CC.R
\name{CC}
\alias{CC}
\title{Clustering Coefficient}
\usage{
CC(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted measures of CC and CCi}
}
\value{
Returns the network's CC
}
\description{
Computes global clustering coefficient CC
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(similarity(sim.fluency(100), method = "cor"))

# Unweighted
cc <- CC(A)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{NeuroImage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
