% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deseq_fc_ecdf.R
\name{deseq_fc_ecdf}
\alias{deseq_fc_ecdf}
\title{Plot the ecdf for DESeq2 log2 Fold Changes}
\usage{
deseq_fc_ecdf(
  res,
  gene.lists,
  title = "ECDF",
  output.filename = NULL,
  palette = SeedMatchR.palette,
  factor.order = NULL,
  x.lims = c(-1, 1),
  stats.test = NULL,
  nboots = 10000,
  null.name = 1,
  target.name = 2,
  keep.boots = TRUE,
  plot.hist = TRUE,
  height = 5,
  width = 10,
  dpi = 320
)
}
\arguments{
\item{res}{The DESeq2 results dataframe}

\item{gene.lists}{A nest list of gene names. Example:
gene.lists = list("Background" = gene.list2, "Target" = gene.list1,
"Overlap" = gene.list3)}

\item{title}{The tile of the plot}

\item{output.filename}{If the output filename is provided, then the plot is
saved.}

\item{palette}{The color palette to use for your curves}

\item{factor.order}{The order to use for the legends}

\item{x.lims}{The xlimits range}

\item{stats.test}{The statistic test to use. Options: KS, Kuiper, DTS, CVM,
AD, Wass}

\item{nboots}{The number of iterations to run the simulation}

\item{null.name}{The name in the gene.list to use as the null for ecdf plots}

\item{target.name}{The name in the gene.list to use as the target for ecdf}

\item{keep.boots}{Whether to keep the results from the boot strapping
analysis}

\item{plot.hist}{Whether to plot the histogram of dstats derived from boost
strap analysis. Keep.boots must be TRUE.}

\item{height}{Plot height in inches}

\item{width}{Plot width in inches}

\item{dpi}{The dpi resolution for the figure}
}
\value{
A ggplot object of the ecdf
}
\description{
This functions will take DESeq2 results as a \code{data.frame} and
plot the ecdf for the input \code{gene.lists}.

The gene sets to plot should be provided as a list of lists.

Example:

\code{gene.lists = list("Background" = c("gene1", "gene2"), "Target" = c("gene2", "gene3"), "Overlap" = c("gene2"))}

This function will also perform statistical testing using the the
\code{twosamples} package if \code{plot.hist} is TRUE. The output will be saved to a
PDF if an \code{output.filename} is provided.

Users can define the groups that are to be compared in the statistical test
using the \code{null.name} and \code{target.name} arguments. The names must be found
in \code{gene.lists}. The \code{factor.order} is used to order the groups in the
analysis.

This functions returns:
\itemize{
\item \verb{$plot}: The ECDF plot
\item \verb{$stats}: The twosamples results object
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

guide.seq = "UUAUAGAGCAAGAACACUGUUUU"

anno.db = load_species_anno_db("human")

features = get_feature_seqs(anno.db$tx.db, anno.db$dna)

# Load test data
get_example_data("sirna")

sirna.data = load_example_data("sirna")

res <- sirna.data$Schlegel_2022_Ttr_D1_30mkg

# Filter DESeq2 results for SeedMatchR
res = filter_deseq(res, fdr.cutoff=1, fc.cutoff=0, rm.na.log2fc = TRUE)

res = SeedMatchR(res, anno.db$gtf, features$seqs, guide.seq, "mer7m8")

# Gene set 1
mer7m8.list = res$gene_id[res$mer7m8 >= 1]

# Gene set 2
background.list = res$gene_id[!(res$mer7m8 \%in\% mer7m8.list)]

ecdf.results = deseq_fc_ecdf(res,
list("Background" = background.list, "mer7m8" = mer7m8.list),
stats.test = "KS",
factor.order = c("Background", "mer7m8"),
null.name = "Background",
target.name = "mer7m8",
nboots = 100)
\dontshow{\}) # examplesIf}
}
