% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{HSS}
\alias{HSS}
\title{Hit Skill Score}
\usage{
HSS(
  dt,
  f = c("below", "normal", "above"),
  o = tc_cols(dt),
  by = by_cols_terc_fc_score(),
  pool = "year",
  dim.check = TRUE
)
}
\arguments{
\item{dt}{Data table containing the predictions.}

\item{f}{column names of the prediction.}

\item{o}{column name of the observations (either in obs_dt, or in dt if obs_dt = NULL). The observation column needs to
contain -1 if it falls into the first category (corresponding to fcs[1]), 0 for the second and 1 for the third category.}

\item{by}{column names of grouping variables, all of which need to be columns in dt.
Default is to group by all instances of month, season, lon, lat, system and lead_time that are columns in dt.}

\item{pool}{column name(s) for the variable(s) along which is averaged, typically just 'year'.}

\item{dim.check}{Logical. If TRUE, the function tests whether the data table contains only one row per coordinate-level, as should be the case.}
}
\value{
A data table with the scores
}
\description{
This score is suitable for tercile category forecasts. The skill score is the difference between the hit scores
for the categories with the highest and lowest probabilities.
}
\examples{
dt = data.table(below = c(0.5,0.3,0),
                normal = c(0.3,0.3,0.7),
                above = c(0.2,0.4,0.3),
                tc_cat = c(-1,0,0),
                year = 1999:2001)
print(dt)
HSS(dt)
}
