% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pie.plot.R
\encoding{UTF-8}
\name{pie.plot}
\alias{pie.plot}
\title{Creates a pie chart using ggplot2.}
\usage{
pie.plot(.data, var, label = var)
}
\arguments{
\item{.data}{the data frame.}

\item{var}{the name of the column to generate the pie chart for.}

\item{label}{The label for the legend.}
}
\description{
Use pie charts with care. See http://www.edwardtufte.com/bboard/q-and-a-fetch-msg?msg_id=00018S
on Edward Tufte's website for good arguments against the use of pie charts.
For a contrary point-of-view, see Spence's article, No Humble Pie: The Origins and
Usage of a Statistical Chart (http://www.psych.utoronto.ca/users/spence/Spence%202005.pdf).
}
\examples{
if (interactive()) {
x = sample(10, 100, rep = TRUE)
z = sample(letters[1:3],100, rep=TRUE)
dat = data.frame(x,z)
pie.plot(dat, 'x', 'z')
}
}

