% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Util_Check_nstud_availability.R
\name{Util_Check_nstud_availability}
\alias{Util_Check_nstud_availability}
\title{Check how many schools in the school registries are included in the students count dataframe}
\source{
\href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0101EDIANAGRAFESTA2021}{Buildings Registry};
\href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Scuole&datasetId=DS0400SCUANAGRAFESTAT}{Schools Registry}
}
\usage{
Util_Check_nstud_availability(
  data,
  Year,
  cutout = c("IC", "IS", "NR"),
  verbose = TRUE,
  ggplot = TRUE,
  toplot_registry = "Any",
  InnerAreas = TRUE,
  ord_InnerAreas = FALSE,
  input_Registry2 = NULL,
  input_InnerAreas = NULL,
  input_Prov_shp = NULL,
  input_AdmUnNames = NULL,
  input_School2mun = NULL,
  autoAbort = FALSE
)
}
\arguments{
\item{data}{Object of class  \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the \code{\link{Util_nstud_wide}} function}

\item{Year}{Numeric or character value. Reference school year.
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023}.}

\item{cutout}{Character. The types of schools not to be taken into account (because not relevant or because they are out of scope in the students number section). By default \code{c("IC", "IS", "NR")} , i.e. the check does not regard comprehensive institutes, superior institutes, and all the schools that cannot be classified either as primary, middle or high schools.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{ggplot}{Logical. If \code{TRUE}, the function displays a static map of the availability of the students number by province (but it does not save the ggplot object into the global environment). \code{TRUE} by default.}

\item{toplot_registry}{Character. If the \code{ggplot} option is chosen, the students number availability of which registry must be plotted; either \code{"Registry1"}, \code{"Registry2"}, \code{"Any"} or \code{"Both"}. \code{"Any"} by default.}

\item{InnerAreas}{Logical. Whether it must be checked if municipalities belong to inner areas or not. \code{TRUE} by default.}

\item{ord_InnerAreas}{Logical. Whether the inner areas classification should be treated as an ordinal variable rather than as a categorical one (see \code{\link{Get_InnerAreas}} for the classification).
\code{FALSE} by default.}

\item{input_Registry2}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_Registry}}
The school registry from the registry section.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{input_InnerAreas}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The classification of peripheral municipalities, obtained as output of the \code{\link{Get_InnerAreas}} function.
Needed only if the \code{InnerAreas} option is chosen.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{input_Prov_shp}{Object of class \code{sf}, \code{tbl_df}, \code{tbl}, \code{data.frame}. The relevant shapefile of Italian municipalities, if the \code{ggplot} option is chosen.
If \code{NULL} it is downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{input_AdmUnNames}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_AdmUnNames}}
The ISTAT file including all the codes and the names of the administrative units for the year in scope.
Only needed if the argument input_School2mun is \code{NULL} and has to be computed.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{input_School2mun}{Object of class \code{list} with elements of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_School2mun}}.
The mapping from school codes to municipality (and province) codes. If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
An object of class \code{list} including two elements:
\itemize{
  \item \code{$Municipality_data}
  \item \code{$Province_data}
}
Both the elements are objects of class \code{list} including four elements:

\itemize{
  \item \code{$Registry1}: object of class of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the availability of the number of students in the schools listed in the buildings section.
  \item \code{$Registry2}: object of class of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the availability of the number of students in the schools listed in the registry section.
  \item \code{$Any}: object of class of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the availability of the number of students in the schools listed anywhere.
  \item \code{$Both}: object of class of class \code{tbl_df}, \code{tbl} and \code{data.frame}: the availability of the number of students in the schools listed in both sections.
}
}
\description{
This function checks for which schools listed in the two registries (the buildings registry and the schools registry)
the count of students is available. The first registry is referred to as as \code{Registry1} and the second one as \code{Registry2}.
}
\examples{

nstud23 <- Util_nstud_wide(example_input_nstud23, verbose = FALSE)

Util_Check_nstud_availability(nstud23, Year = 2023,
  input_Registry2 = example_input_Registry23, InnerAreas = FALSE,
  input_School2mun = example_School2mun23, input_Prov_shp = example_Prov22_shp)





}
