\name{evalSolution}
\Rdversion{1.3}
\alias{evalSolution}
\title{
Evaluation of the solution produced by the function 'optimizeStrata' by
selecting a number of samples from the frame with the optimal stratification, and calculating average CV's on the target variables Y's.
}
\description{
The user can indicate the number of samples that must be selected by the optmized frame. First, the true values of the parameters are calculated from the frame. Then, for each sample the sampling estimates are calculated, together with the differences between them and the true values of the parameters.
At the end, an estimate of the CV is produced for each target variable, in order to compare them
with the precision constraints set at the beginning of the optimization process.
If the flag 'writeFiles' is set to TRUE, boxplots of distribution of the CV's in the different 
domains are produced for each Y variable ('cv.pdf'),
together with boxplot of the distributions of differences between estimates and values of the parameters
in the population ('differences.pdf').

}
\usage{
evalSolution(frame,
		outstrata,
		nsampl=100,
		cens=NULL,
		writeFiles=TRUE,
		progress=TRUE)
}
\arguments{
  \item{frame}{
The frame to which the optimal stratification has been applied.
	}
  \item{outstrata}{
The new (aggregated) strata generated by the function 'optimizeStrata'.
	}
  \item{nsampl}{
The number of samples to be drawn from the frame.
	}
\item{cens}{
	A dataframe containing units to be selected in any cases.
	}
  \item{writeFiles}{
A flag to write in the work directory the outputs of the function. Default is TRUE.
	}
	\item{progress}{
  If set to TRUE, a progress bar is visualised during the execution. Default is TRUE.
  }
}
\value{
A list containing (i) the CV distribution in the domains and (ii) the bias distribution in the domains
}

\author{
Giulio Barcaroli
}

\examples{
\dontrun{
library(SamplingStrata)
data(swisserrors)
data(swissstrata)
solution <- optimizeStrata (
	errors = swisserrors,
	strata = swissstrata,
)
# update sampling strata with new strata labels
newstrata <- updateStrata(swissstrata, solution, writeFiles = TRUE)
# update sampling frame with new strata labels
data(swissframe)
framenew <- updateFrame(frame=swissframe,newstrata=newstrata,writeFile=TRUE)
samp <- selectSample(framenew,solution$aggr_strata,writeFiles=TRUE)
# evaluate the current solution
results <- evalSolution(framenew, solution$aggr_strata, 10, cens=NULL, writeFiles = TRUE)
results$coeff_var
results$rel_bias
}
}
\keyword{ survey }