% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSize4ClinicalTrials.R
\name{ssc}
\alias{ssc}
\title{Sample Size Calculation for the Comparison of Means or Proportions in Phase III Clinical Trials}
\usage{
ssc(cat=c("m","p"), design=c(1,2,3,4), ratio, alpha, power, sigma, p1, p2, theta, delta)
}
\arguments{
\item{cat}{Type of the outcome for comparison.
\cr "m"
  \cr stands for the comparison of means.
\cr "p"
  \cr stands for the comparison of proportions.}

\item{design}{The design of the clinical trials.
\cr 1
  \cr Testing for equality
\cr 2
  \cr Superiority trial
\cr 3
  \cr Non-inferiority trial
\cr 4
  \cr Equivalence trial.}

\item{ratio}{The ratio between the number of subjects in the treatment arm and that in the control arm.}

\item{alpha}{Type I error rate}

\item{power}{Statistical power of the test (1-type II error rate)}

\item{sigma}{The variance of observed outcomes in both arms (specified in the comparison of means for continuous outcomes)}

\item{p1}{The response rate of the treatment arm (specified the comparison of proportions for binary outcomes)}

\item{p2}{The response rate of the control arm}

\item{theta}{The difference between means or proportions in the two arms}

\item{delta}{The prespecified non-inferiority or equivalence margin in non-inferiority or equivalence trials}
}
\value{
samplesize
}
\description{
This function aims to calculate sample size for the comparison of means or proportions
in Phase III clinical trials.
}
\examples{
##The comparison of means, a non-inferiority trial with a non-inferiority margin 0.5
##the true treatment difference is assumed to be zero in non-inferiority and equivalence trials
ssc(cat="m",design=3,ratio=1,alpha=0.05,power=0.9,sigma=1,theta=0,delta=0.5)
##The comparison of proportions, a superiority trial
ssc(cat="p",design=2,ratio=3,alpha=0.025,power=0.8,p1=0.4,p2=0.2,theta=0.2)
}
\references{
Yin, G. (2012). Clinical Trial Design: Bayesian and Frequentist Adaptive Methods. John Wiley & Sons.
}
