% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/res_custom_sk_map.R
\name{res_custom_sk_map}
\alias{res_custom_sk_map}
\title{Local Reserve Map With Seasonal Kendall Results for Custom Stations}
\usage{
res_custom_sk_map(
  stations,
  x_loc,
  y_loc,
  sk_result = NULL,
  bbox,
  shp,
  station_labs = TRUE,
  lab_loc = NULL,
  bg_map = NULL,
  zoom = NULL,
  maptype = "toner-lite"
)
}
\arguments{
\item{stations}{chr string of the reserve stations to include in the map}

\item{x_loc}{num vector of x coordinates for \code{stations}. East longitudes
must be negative.}

\item{y_loc}{num vector of y coordinates for \code{stations}}

\item{sk_result}{vector of values denoting direction and significance of
seasonal kendall results. Result should be c('inc', 'dec', 'insig') for
sig. negative, no sig. results, and sig. positive result}

\item{bbox}{a bounding box associated with the reserve. Must be in the format
of c(X1, Y1, X2, Y2)}

\item{shp}{{sf} data frame (preferred) or SpatialPolygons object}

\item{station_labs}{logical, should stations be labeled? Defaults to
\code{TRUE}}

\item{lab_loc}{chr vector of 'R' and 'L', one letter for each station. if no
\code{lab_loc} is specified then labels will default to the left.}

\item{bg_map}{a georeferenced \code{ggmap} or \code{ggplot} object used as a
background map, generally provided by a call to \code{\link{base_map}}. If
\code{bg_map} is specified, \code{maptype} and \code{zoom} are ignored.}

\item{zoom}{Zoom level for the base map created when \code{bg_map} is not
specified.  An integer value, 5 - 15, with higher numbers providing  more
detail.  If not provided, a zoom level is autoscaled based on \code{bbox}
parameters.}

\item{maptype}{Background map type from Stamen Maps
(\url{http://maps.stamen.com/}); one of c("terrain", "terrain-background",
"terrain-labels", "terrain-lines", "toner", "toner-2010", "toner-2011",
"toner-background", "toner-hybrid", "toner-labels", "toner-lines",
"toner-lite", "watercolor").}
}
\value{
returns a {ggplot} object
}
\description{
Create a stylized reserve-level map of seasonal kendall results from custom
station locations for use with the reserve level reporting template
}
\details{
Creates a stylized, reserve-level base map for displaying seasonal
  kendall results from \code{\link{sk_seasonal}}. The user can specify the
  reserve and stations to plot. The user can also specify a bounding box. For
  multi-component reserves, the user should specify a bounding box that
  highlights the component of interest.

  To display seasonal trends, the user must specify \code{c('inc', 'dec',
  'insig', 'insuff')} for each station listed in the \code{stations}
  argument.
}
\examples{
### set plotting parameters
stns <- c('Stn 1', 'Stn 2')
x_coords <- c(-121.735281, -121.750369)
y_coords <- c(36.850377, 36.806667)
shp_fl <- elk_spatial
bounding_elk <- c(-121.8005, 36.7779, -121.6966, 36.8799)
lab_dir <- c('R', 'L')
trnds <- c('inc', 'dec')

### Low zoom and default maptype plot (for CRAN testing, not recommended)
#    Lower zoom number gives coarser text and fewer features
(x_low <- res_custom_sk_map(stations = stns, x_loc = x_coords,
                  sk_result = trnds, y_loc = y_coords,
                  bbox = bounding_elk, lab_loc = lab_dir,
                  shp = shp_fl, zoom = 10))
\donttest{
### Default zoom and maptype plot
x_def <- res_custom_sk_map(stations = stns, x_loc = x_coords,
                  sk_result = trnds, y_loc = y_coords,
                  bbox = bounding_elk, lab_loc = lab_dir,
                  shp = shp_fl)

### Higher zoom number gives more details, but may not be visible
x_14 <- res_custom_sk_map(stations = stns, x_loc = x_coords,
                  sk_result = trnds, y_loc = y_coords,
                  bbox = bounding_elk, lab_loc = lab_dir,
                  shp = shp_fl, zoom = 14)


### Different maptypes may be used.  All may not be available.
#   Note that zoom and maptype interact, so some experimentation may be
#   required.
x_terrain <- res_custom_sk_map(stations = stns, x_loc = x_coords,
                  sk_result = trnds, y_loc = y_coords,
                  bbox = bounding_elk, lab_loc = lab_dir,
                  shp = shp_fl, maptype = 'terrain')
}
}
\author{
Julie Padilla, Dave Eslinger
}
\concept{analyze}
