% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countrySummary_mult.R
\name{countrySummary_mult}
\alias{countrySummary_mult}
\title{Obtain the Horvitz-Thompson direct estimates and standard errors using delta method for multiple surveys.}
\usage{
countrySummary_mult(births, years, idVar = "v002", regionVar = "region",
  timeVar = "per5", clusterVar = "~v001+v002", ageVar = "ageGrpD",
  weightsVar = "v005", geo.recode = NULL)
}
\arguments{
\item{births}{A list of child-month data from multiple surveys from \code{\link{getBirths}}. The name of the list is used as the identifier in the output.}

\item{years}{String vector of the year intervals used}

\item{idVar}{Variable name for ID, typically 'v002'}

\item{regionVar}{Variable name for region, typically 'v024', for older surveys might be 'v101'}

\item{timeVar}{Variable name for time, typically 'per5'}

\item{clusterVar}{Variable name for cluster, typically '~v001 + v002'}

\item{ageVar}{Variable name for age group, default assumes the variable is called 'ageGrpD'}

\item{weightsVar}{Variable name for sampling weights, typically 'v005'}

\item{geo.recode}{The recode matrix to be used if region name is not consistent across different surveys. See \code{\link{ChangeRegion}}.}
}
\value{
a matrix of period-region summary of the Horvitz-Thompson direct estimates, the standard errors using delta method for a single survey, the 95\% confidence interval, the logit of the estimates, and the survey labels.
}
\description{
Obtain the Horvitz-Thompson direct estimates and standard errors using delta method for multiple surveys.
}
\examples{
\dontrun{
data(DemoData)
years <- c("85-89", "90-94", "95-99", "00-04", "05-09", "10-14")
u5m <- countrySummary_mult(births = DemoData, years = years, idVar = "id", 
regionVar = "region", timeVar = "time", clusterVar = "~clustid+id", 
ageVar = "age", weightsVar = "weights", geo.recode = NULL)
}
}
\seealso{
\code{\link{countrySummary}}
}
