% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample.partial.tt}
\alias{sample.partial.tt}
\title{Resample the subtree rooted at any tree node, keeping the annotations for the rest of the tree fixed}
\usage{
sample.partial.tt(generator, count = 1, unsampled = 0,
  starting.node = phangorn::getRoot(generator$tree), existing = NULL,
  check.integrity = TRUE, draw = count == 1, igraph = FALSE,
  verbose = FALSE)
}
\arguments{
\item{generator}{A list of class \code{tt.generator} produced by \code{tt.generator}.}

\item{count}{How many transmission trees to sample.}

\item{unsampled}{The number of unsampled hosts in the transmission chain. (The whole transmission chain, even if only part of the transmission tree is being resampled). A value >0 requires a \code{generator} list whose \code{type} is \code{unsampled}.}

\item{starting.node}{The root of the subtree to resample. If this is the root of the whole tree, then \code{existing} is irrelevent (but generally \code{sample.tt} should be used for this purpose).}

\item{existing}{An existing list of class \code{tt}, representing a transmission tree to be modified. Usually these are produced by a \code{sample.tt} or \code{sample.partial.tt} call.}

\item{check.integrity}{Whether to check if \code{existing} is indeed a valid transmission tree.}

\item{draw}{Use \code{ggtree} to draw a coloured phylogeny showing each transmission tree overload onto the phylogeny}

\item{igraph}{Produce the transmission trees in \code{igraph} format.}

\item{verbose}{Verbose output}
}
\value{
A list, each of whose elements is a list of class \code{tt} with one or more of the following elements:
\itemize{
\item{\code{annotations}}{ Always present. A vector indicating which host (given by numbers corresponding to the ordering in \code{generator$hosts}) is assigned to each phylogeny node.}
\item{\code{edgelist}}{ Always present. A \code{data.frame} giving the edge list; the first column are parents and the second children.}
\item{\code{hidden}}{ Present if \code{unsampled} is greater than 0. The number of "hidden" unsampled hosts (with no associated nodes) along each branch.}
\item{\code{picture}}{ Present if \code{draw} was TRUE; a \code{ggtree} object.}
\item{\code{igraph}}{ Present if \code{igraph} was TRUE; an \code{igraph} object.}
}
}
\description{
Resample the subtree rooted at any tree node, keeping the annotations for the rest of the tree fixed
}
\examples{
# draw one sample from the uniform distribution
generator <- tt.generator(stratus.example.tree)
samples <- sample.tt(generator, 1, draw = TRUE)
original.tt <- samples[[1]]
# sample anew, from node 31 downwards
revised.tt <- sample.partial.tt(generator, 1, starting.node = 31, 
    existing = original.tt, draw = TRUE)
}
