\name{CRITERIA}

\alias{AOPT}
\alias{CDMAX}
\alias{CDMAX0}
\alias{CDMAX2}
\alias{CDMEAN}
\alias{CDMEAN0}
\alias{CDMEAN2}
\alias{CDMEANMM}
\alias{DOPT}
\alias{EOPT}
\alias{GAUSSMEANMM}
\alias{GOPTPEV}
\alias{GOPTPEV2}
\alias{PEVMAX}
\alias{PEVMAX0}
\alias{PEVMAX2}
\alias{PEVMEAN}
\alias{PEVMEAN0}
\alias{PEVMEAN2}
\alias{PEVMEANMM}


\title{Optimality Criteria}
\description{
These are some default design criteria to be minimized. There is a table in the details section that gives the formula for each design criterion and describes their usage. Note that the inputs for these functions come in 2 syntax flavors, namely Type-X and Type-K. Users can define and use their owm design criteria as long as it has the Type-X syntax as shown with the examples.  
}
\usage{
AOPT(Train, Test, P, lambda = 1e-05, C=NULL)
CDMAX(Train, Test, P, lambda = 1e-05, C=NULL)
CDMAX0(Train, Test, P, lambda = 1e-05, C=NULL)
CDMAX2(Train, Test, P, lambda = 1e-05, C=NULL)
CDMEAN(Train, Test, P, lambda = 1e-05, C=NULL)
CDMEAN0(Train, Test, P, lambda = 1e-05, C=NULL)
CDMEAN2(Train, Test, P, lambda = 1e-05, C=NULL)
CDMEANMM(Train, Test, Kinv,K, lambda = 1e-05, C=NULL, Vg=NULL, Ve=NULL)
DOPT(Train, Test, P, lambda = 1e-05, C=NULL)
EOPT(Train, Test, P, lambda = 1e-05, C=NULL)
GAUSSMEANMM(Train, Test, Kinv, K, lambda = 1e-05, C=NULL, Vg=NULL, Ve=NULL)
GOPTPEV(Train, Test, P, lambda = 1e-05, C=NULL)
GOPTPEV2(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMAX(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMAX0(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMAX2(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMEAN(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMEAN0(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMEAN2(Train, Test, P, lambda = 1e-05, C=NULL)
PEVMEANMM(Train, Test, Kinv,K, lambda = 1e-05, C=NULL, Vg=NULL, Ve=NULL)

}
\arguments{
    \item{Train}{
vector of identifiers for individuals in the training set
}
  \item{Test}{
vector of identifiers for individuals in the test set
}
  \item{P}{ (Only for Type-X)
\eqn{n \times k} matrix of the first PCs of the predictor variables. The matrix needs to have union of the identifiers of the candidate and test individuals as rownames.
}

 \item{Kinv}{ (Only for Type-K)
\eqn{n \times n} symmetric matrix (inverse of the relationship matrix K  between n individuals) with row and column names.
}
 \item{K}{ (Only for Type-K)
\eqn{n \times n} symmetric matrix (the relationship matrix K  between n individuals).
}
\item{lambda}{
scalar shrinkage parameter (\eqn{\lambda>0}).
}
 \item{C}{
Contrast Matrix.
}
 \item{Vg}{ (Only for PEVMEANMM)
covariance matrix between traits generated by the relationship K (multi-trait version).
}
 \item{Ve}{ (Only for PEVMEANMM)
residual covariance matrix for the traits (multi-trait version). 
}
}
\value{value of the criterion.}
\details{
\tabular{lllllllllllllllllllll}{
  \strong{criterion name}\tab \strong{formula} \tab \strong{Type} \cr
 

   AOPT \tab \eqn{trace[C(P'_{Train}P_{Train}+lambda*I)^{-1}C']} \tab X \cr
   \tab   \tab  \cr

  CDMAX \tab \eqn{max[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C')/} \tab X \cr
   \tab \eqn{diag(CP_{Test}P'_{Test}C')]}   \tab  \cr

  CDMAX0 \tab \eqn{max[diag(CP_{Train}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}C')/} \tab X \cr
   \tab \eqn{diag(CP_{Train}P'_{Train}C')]}   \tab  \cr
   
 CDMAX2 \tab \eqn{max[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}P_{Train}} \tab X \cr
   \tab  \eqn{(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C')/diag(CP_{Test}P'_{Test}C')]} \tab  \cr

  CDMEAN \tab \eqn{mean[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C')/} \tab X \cr
   \tab \eqn{diag(CP_{Test}P'_{Test}C')]}  \tab  \cr
    
  CDMEAN0 \tab  \eqn{mean[diag(CP_{Train}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}C')/} \tab X \cr
   \tab \eqn{diag(CP_{Train}P'_{Train}C')]}  \tab  \cr

   CDMEAN2 \tab  \eqn{mean[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}P_{Train}} \tab X \cr
   \tab  \eqn{(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C')/diag(CP_{Test}P'_{Test}C')] } \tab  \cr

  CDMEANMM \tab \eqn{-mean[diag(CZ_{Test}(K-lambda*(Z_{Train}'MZ_{Train})^{-1}+\lambda*Kinv)Z_{Test}'C')/}  \tab K \cr
   \tab \eqn{(diag(CZ_{Test}KZ_{Test}'C'))]}   \tab  \cr

  DOPT \tab  \eqn{logdet(C(P'_{Train}P_{Train}+lambda*I))^{-1}C'} \tab X \cr
   \tab   \tab  \cr

  EOPT \tab \eqn{max(eigenval(C(P'_{Train}P_{Train}+lambda*I))^{-1}C'))} \tab X \cr
   \tab   \tab  \cr

   GAUSSMEANMM \tab   \eqn{-mean(diag(Z_{Test}KZ_{Test}'-}  \tab  K \cr
   \tab \eqn{Z_{Test}KZ_{Train}'(Z_{Train}KZ_{Train}'+\lambda*I_{ntrain})^{-1}Z_{Train}KZ_{Test}')}  \tab  \cr

  GOPTPEV \tab \eqn{max(eigenval(CP_{Test}(P_{Train}'P_{Train}+\lambda*I_{ntrain})^{-1}P_{Test}'C'))} \tab X \cr
   \tab   \tab  \cr

  GOPTPEV2 \tab \eqn{mean(eigenval(CP_{Test}(P_{Train}'P_{Train}+\lambda*I_{ntrain})^{-1}P_{Test}'C'))} \tab X \cr
   \tab   \tab  \cr

   PEVMAX \tab   \eqn{max(diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C'))} \tab X \cr
   \tab   \tab  \cr

  PEVMAX0 \tab  \eqn{max(diag(CP_{Train}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}C'))} \tab X \cr
   \tab   \tab  \cr

  PEVMAX2 \tab  \eqn{max[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}P_{Train}}  \tab X \cr
   \tab  \eqn{(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C']} \tab  \cr

  PEVMEAN \tab  \eqn{mean(diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C'))}  \tab X \cr
   \tab   \tab  \cr


  PEVMEAN0 \tab \eqn{mean(diag(CP_{Train}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Train}C'))} \tab X \cr
   \tab   \tab  \cr
  
  PEVMEAN2 \tab \eqn{mean[diag(CP_{Test}(P'_{Train}P_{Train}+lambda*I)^{-1}} \tab X \cr
   \tab  \eqn{P'_{Train}P_{Train}(P'_{Train}P_{Train}+lambda*I)^{-1}P'_{Test}C']}  \tab  \cr
   
   PEVMEANMM \tab \eqn{mean(diag(CZ_{test}(Ztrain'MZtrain+lambda*Kinv)^{-1}Ztest'C')))} \tab K \cr
   \tab   \tab  \cr
 }
}

\examples{
	\dontrun{
#Examples to new criterion:
#1- PEVmax
STPGAUSERFUNC<-function(Train,Test, P, lambda=1e-6, C=NULL){
  PTrain<-P[rownames(P)\%in\%Train,]
  PTest<-P[rownames(P)\%in\%Test,]
  if (length(Test)==1){PTest=matrix(PTest, nrow=1)}
  if (!is.null(C)){ PTest<-C\%*\%PTest}
  PEV<-PTest\%*\%solve(crossprod(PTrain)+lambda*diag(ncol(PTrain)),t(PTrain))
    PEVmax<-max(diag(tcrossprod(PEV)))
  return(PEVmax)
}




######Here is an example of usage
data(iris)
#We will try to estimate petal width from
#variables sepal length and width and petal length.
X<-as.matrix(iris[,1:4])
distX<-as.matrix(dist(X))
rownames(distX)<-colnames(distX)<-rownames(X)<-paste(iris[,5],rep(1:50,3),sep="_" )
#test data 25 iris plants selected at random from the virginica family,
#candidates are the plants in the  setosa and versicolor families.
candidates<-rownames(X)[1:100]
test<-sample(setdiff(rownames(X),candidates), 25)
#want to select 25 examples using the criterion defined in STPGAUSERFUNC
#Increase niterations and npop substantially for better convergence.
ListTrain<-GenAlgForSubsetSelection(P=distX,Candidates=candidates,
Test=test,ntoselect=25,npop=50,
nelite=5, mutprob=.8, niterations=30,
lambda=1e-5, errorstat="STPGAUSERFUNC", plotiters=TRUE)
}
}
\author{Deniz Akdemir}

