% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{STSIdentifySTMotifs}
\alias{STSIdentifySTMotifs}
\title{Check of candidates}
\usage{
STSIdentifySTMotifs(candidates, ka = 1, si = 1)
}
\arguments{
\item{candidates}{List which contains the discovered motifs}

\item{ka}{Support for Spatial Occurrence (SO)}

\item{si}{Support of Global Occurrence (GO)}
}
\value{
Return a list of motifs [Isaxcode, Recmatrix, Vectst] which past the tresholds sigma and kappa, each motif contains :

Isaxcode : Motif sequences in character format

Recmatrix : Matrix giving as information the blocks containing this motif

Vectst : Coordinate of the start positions of the motif in the original dataset
}
\description{
First step in controlling the quality of candidates
}
\note{
To see how candidates are validated (see part 1) : \href{../inst/doc/check-candidates.html}{Validation of candidates}
}
\examples{
#Generation of candidates
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)

#Treatment of candidates
stmotifs <- STSIdentifySTMotifs(candidates, 1, 1)
}
