% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_aggregate.R
\name{dummy_aggregate}
\alias{dummy_aggregate}
\title{\code{aggregate_multiple_fun} using a dummy matrix}
\usage{
dummy_aggregate(data, x, fun, vars = NULL, ...)
}
\arguments{
\item{data}{A data frame containing data to be aggregated}

\item{x}{A (sparse) dummy matrix}

\item{fun}{A named list of functions. These names will be used as suffixes in output variable names. Name can be omitted for one function.
A vector of function as strings is also possible. When unnamed, these function names will be used directly.
See the examples of \code{\link{fix_fun_amf}}, which is the function used to convert \code{fun}.
Without specifying \code{fun}, the functions, as strings, are taken from the function names coded in \code{vars}.}

\item{vars}{A named vector or list of variable names in \code{data}. The elements are named by the names of \code{fun}.
All the pairs of variable names and function names thus define all the result variables to be generated.
Parameter \code{vars} will converted to an internal standard by the function \code{\link{fix_vars_amf}}.
Thus, function names and also output variable names can be coded in different ways.
Multiple output variable names can be coded using \code{multi_sep}.
See examples and examples in \code{\link{fix_vars_amf}}.
Indices instead of variable names are allowed.}

\item{...}{Further arguments passed to \code{aggregate_multiple_fun}}
}
\value{
data frame
}
\description{
Wrapper to \code{\link{aggregate_multiple_fun}}
that uses a dummy matrix instead of the \code{by} parameter
}
\details{
Internally this function make use of the \code{ind} parameter to \code{aggregate_multiple_fun}
}
\examples{

# Code that generates output similar to the 
# last example in aggregate_multiple_fun

z2 <- SSBtoolsData("z2")
set.seed(12)
z2$y <- round(rnorm(nrow(z2)), 2)
z <- z2[sample.int(nrow(z2), size = 20), ]

x <- ModelMatrix(z, formula = ~hovedint:kostragr - 1)

# with specified output variable names
my_range <- function(x) c(min = min(x), max = max(x))
dummy_aggregate(
   data = z, 
   x = x, 
   fun = c(sum, ra = my_range, wmean = weighted.mean),    
   vars = list("ant", "y", 
               `antmin,antmax` = list(ra = "ant"), 
                yWmean  = list(wmean  = c("y", "ant")))
)

}
\seealso{
\code{\link{aggregate_multiple_fun}}
}
