% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forEasySdcTable.R
\encoding{UTF8}
\name{HierarchicalGroups}
\alias{HierarchicalGroups}
\title{Finding hierarchical variable groups}
\usage{
HierarchicalGroups(
  x = NULL,
  mainName = TRUE,
  eachName = FALSE,
  fCorr = FactorLevCorr(x)
)
}
\arguments{
\item{x}{Matrix or data frame containing the variables}

\item{mainName}{When TRUE output list is named according to first variable in group.}

\item{eachName}{When TRUE variable names in output instead of indices.}

\item{fCorr}{When non-null x is not needed as input.}
}
\value{
Output is a list containing the groups. First variable has most levels.
}
\description{
According to the (factor) levels of the variables
}
\examples{
 x <- rep(c("A","B","C"),3)
 y <- rep(c(11,22,11),3)
 z <- c(1,1,1,2,2,2,3,3,3)
 zy <- paste(z,y,sep="")
 m <- cbind(x,y,z,zy)
 HierarchicalGroups(m)
}
\author{
Øyvind Langsrud
}
