% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.SPQR.R
\name{predict.SPQR}
\alias{predict.SPQR}
\title{predict method for class \code{SPQR}}
\usage{
\method{predict}{SPQR}(
  object,
  X,
  Y = NULL,
  nY = 101,
  type = c("QF", "PDF", "CDF"),
  tau = seq(0.1, 0.9, 0.1),
  ci.level = 0,
  getAll = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{X}{The covariate vector/matrix for which the predictions are computed.}

\item{Y}{The response vector for which the predictions are computed. Default is \code{NULL}
indicating that a equi-distant grid vector on [0,1] of length \code{nY} is used.}

\item{nY}{An integer number indicating length of grid when \code{Y} is not specified. Default: 101.}

\item{type}{The function to be predicted; \code{"PDF"}: probability density function,
\code{"CDF"}: cumulative distribution function, and \code{"QF"}: the quantile function (default).}

\item{tau}{The grid of quantiles for which the quantile function is computed. Default: \code{seq(0.1,0.9,0.1)}.}

\item{ci.level}{The credible level for computing the pointwise credible intervals. The
default is 0 indicating no credible intervals should be computed.}

\item{getAll}{If \code{TRUE}, extracts all posterior samples of the prediction. Default: \code{FALSE}.}

\item{...}{Other arguments.}
}
\value{
A named array containing all predicted values.
}
\description{
Computes the predicted values for different functions based on the fitted \code{"SPQR"} object.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## compute the estimated PDF of Y conditioned on X = 0
pdf <- predict(fit, type = "PDF", X = 0, Y = seq(0, 1, 0.01))
plot(seq(0, 1, 0.01), pdf, xlab = "Y", ylab = "Density")
}
}
