% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.SPQR.R
\name{autoplot.SPQR}
\alias{autoplot.SPQR}
\title{autoplot method for class \code{SPQR}}
\usage{
\method{autoplot}{SPQR}(object, output = c("GOF", "estimator", "trace", "QALE", "QVI"), ...)
}
\arguments{
\item{object}{An object of class \code{SPQR}.}

\item{output}{A character indicating the type of plot to be returned.

\itemize{
  \item \code{"GOF"}: goodness of fit test by comparing the quantiles of probability integral transform (PIT) to that of uniform distribution.
  \item \code{"estimator"}: visualization of various estimates, including probability density function (PDF), cumulative density function (CDF) and quantile function (QF).
  \item \code{"trace"}: diagnostic trace plots for SPQR fitted with \code{method = "MCMC"}.
  \item \code{"QALE"}: quantile accumulative local effects (ALE) for visualizing covariate effects on predicted quantiles.
  \item \code{"QVI"}: quantile variable importance comparison.
}}

\item{...}{arguments passed into specific plot function, see \code{\link[=plotEstimator]{plotEstimator()}}, \code{\link[=plotGOF]{plotGOF()}}, \code{\link[=plotMCMCtrace]{plotMCMCtrace()}},
\code{\link[=plotQALE]{plotQALE()}} or \code{\link[=plotQVI]{plotQVI()}} for required arguments.}
}
\value{
a \code{ggplot} object
}
\description{
The function calls one of the following functions:
\code{\link[=plotEstimator]{plotEstimator()}}, \code{\link[=plotGOF]{plotGOF()}}, \code{\link[=plotMCMCtrace]{plotMCMCtrace()}},
\code{\link[=plotQALE]{plotQALE()}}, \code{\link[=plotQVI]{plotQVI()}}
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
control <- list(iter = 200, warmup = 150, thin = 1)
fit <- SPQR(X = X, Y = Y, method = "MCMC", control = control,
            normalize = TRUE, verbose = FALSE)

## Goodness-of-fit test
autoplot(fit, output = "GOF")
}
}
