% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssummarymodel.R
\name{sSummaryModel}
\alias{sSummaryModel}
\title{Collects All Models Specified by "sarimaSpec"}
\usage{
sSummaryModel(
  x,
  maxorder = c(3, 1, 2),
  period = 12,
  criterion = "bic",
  method = "CSS"
)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{maxorder}{Maximum order of ARIMA model \eqn{(p,d,q)} where \eqn{p} is the AR order, \eqn{d} the degree of differencing,
and \eqn{q} the MA order. Default value is (3,1,2).}

\item{period}{Seasonal period. The default is 12.}

\item{criterion}{Information criterion used for model selection. Either AIC or BIC.
Default is "bic".}

\item{method}{Estimation method. See the arima command in R. Possible values are "CSS-ML", "ML", and "CSS".
Default is "CSS".}
}
\value{
A list containing:
\itemize{
  \item Order - Order of ARIMA model \eqn{(p, d, q, P, D, Q)} of each series. A matrix of (ncol(x),6). The six columns are "p","d","q", "P", "D", "Q".
  \item Mean - A logical vector indicating whether each series needs a constant (or mean).
  \item M1 - Contains orders the stationary series.
  \item M2 - Contains orders of series with (d=1) and (D=0).
  \item M3 - Contains orders of  series with (d=2) and (D=0).
  \item M4 - Contains orders of series with (d=0) and (D=1).
  \item M5 - Contains orders of series with (d=1) and (D=1).
  \item M6 - Contains orders of series with (d=2) and (D=1).
}
}
\description{
Models specified by "sarimaSpec".
}
\examples{
data(TaiwanAirBox032017)
summary <- sSummaryModel(TaiwanAirBox032017[,1:3])

}
