% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipd_packages.R
\name{sipd_packages}
\alias{sipd_packages}
\title{Indicate names of the packages inside SIPDIBGE}
\usage{
sipd_packages(survey = NULL)
}
\arguments{
\item{survey}{Name of the household survey for reference package information. If \code{NULL}, presents the information of all the packages inside this collection.}
}
\value{
A vector with names of the packages inside SIPDIBGE.
}
\description{
This function describes the packages inside SIPDIBGE.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
sipd_packages()
# Presenting information about the COVIDIBGE package
sipd_packages(survey="COVID")
# Presenting information about the PNADcIBGE package
sipd_packages(survey="PNADC")
# Presenting information about the PNSIBGE package
sipd_packages(survey="PNS")}
}
\seealso{
\link[SIPDIBGE]{sipd_conflicts} for indicating conflicts of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_deps} for indicating dependencies of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_logo} for showing logos of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_sitrep} for indicating version information for the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_update} for indicating the existence of an update for the packages inside SIPDIBGE.
}
