% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isNULLColonies}
\alias{isNULLColonies}
\title{Check which of the colonies in a multicolony are NULL}
\usage{
isNULLColonies(multicolony)
}
\arguments{
\item{multicolony}{\code{\link[SIMplyBee]{MultiColony-class}}}
}
\value{
Named vector of boolean
}
\description{
Check which of the colonies in a multicolony are NULL
}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

emptyApiary <- createMultiColony(n = 3)
emptyApiary1 <- c(createColony(), createColony())
nonEmptyApiary <- createMultiColony(basePop[2:5], n = 4)

isEmpty(emptyApiary)
isEmpty(emptyApiary1)
isEmpty(nonEmptyApiary)
isNULLColonies(emptyApiary)
isNULLColonies(emptyApiary1)
isNULLColonies(nonEmptyApiary)

nEmptyColonies(emptyApiary)
nEmptyColonies(emptyApiary1)
nEmptyColonies(nonEmptyApiary)
nNULLColonies(emptyApiary)
nNULLColonies(emptyApiary1)
nNULLColonies(nonEmptyApiary)

}
