% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{createMatingStationDCA}
\alias{createMatingStationDCA}
\title{Create a DCA of drones at a mating stations}
\usage{
createMatingStationDCA(
  colony,
  nDPQs = 20,
  nDronePerDPQ = NULL,
  simParamBee = NULL
)
}
\arguments{
\item{colony}{\code{\link{Colony-class}} to produce drone producing queens from}

\item{nDPQs}{integer, the number of drone producing queens}

\item{nDronePerDPQ}{integer, number of drones each DPQ contributed to the DCA}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link{Pop-class}} with created drones resembling a DCA at a mating station
}
\description{
Level 1 function that creates a DCA at a classical honeybee
  mating station of several sister drone producing queens. The
  functions first creates multiple drone producing queens (DPQs) from one colony;
  and second, produces drones from the DPQs. All the created drones form a
  DCA at a mating station.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create a colony and cross it
colony1 <- createColony(x = basePop[2])
colony1 <- cross(colony1, drones = droneGroups[[1]])

# Create a empty colony
colony2 <- createColony(x = basePop[3])

# Create a mating station from colony1
matingStation <- createMatingStationDCA(colony1, nDPQs = 20, nDronePerDPQ = 10)

# Cross colony2 on the mating station
fathers <- pullDroneGroupsFromDCA(matingStation, n = 1, nDrones = 15)
colony2 <- cross(colony2, drones = fathers[[1]])
nFathers(colony2)

}
