% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.2008RJB.R
\name{norm.2008RJB}
\alias{norm.2008RJB}
\title{Robust Jarque-Bera Test of Univariate Normality by Gel and Gastwirth (2008)}
\usage{
norm.2008RJB(x, C1 = 6, C2 = 24, method = c("asymptotic", "MC"), nreps = 2000)
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{C1}{a control constant. Authors proposed \eqn{C1=6} for nominal level of \eqn{\alpha=0.05}.}

\item{C2}{a control constant. Authors proposed \eqn{C2=24} for nominal level of \eqn{\alpha=0.05}.}

\item{method}{method to compute \eqn{p}-value. Using initials is possible, \code{"a"} for asymptotic for example.}

\item{nreps}{the number of Monte Carlo simulations to be run when \code{method="MC"}.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given an univariate sample \eqn{x}, it tests
\deqn{H_0 : x\textrm{ is from normal distribution} \quad vs\quad H_1 : \textrm{ not } H_0}
using a test procedure by Gel and Gastwirth (2008), which is a robustified version Jarque-Bera test.
}
\examples{
## generate samples from uniform distribution
x = runif(28)

## test with both methods of attaining p-values
test1 = norm.2008RJB(x, method="a") # Asymptotics
test2 = norm.2008RJB(x, method="m") # Monte Carlo 

}
\references{
\insertRef{gel_robust_2008}{SHT}
}
