% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meank.2019CPH.R
\name{meank.2019CPH}
\alias{meank.2019CPH}
\title{Test for Equality of Means by Cao, Park, and He (2019)}
\usage{
meank.2019CPH(dlist, method = c("original", "Hu"))
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample matrix of same dimension.}

\item{method}{a method to be applied to estimate variance parameter. \code{"original"} for the estimator 
proposed in the paper, and \code{"Hu"} for the one used in 2017 paper by Hu et al. Case insensitive and initials can be used as well.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \mu_1 = \cdots \mu_k\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Cao, Park, and He (2019).
}
\examples{
## CRAN-purpose small example
tinylist = list()
for (i in 1:3){ # consider 3-sample case
  tinylist[[i]] = matrix(rnorm(10*3),ncol=3)
}
meank.2019CPH(tinylist, method="o") # newly-proposed variance estimator
meank.2019CPH(tinylist, method="h") # adopt one from 2017Hu

\donttest{
## test when k=5 samples with (n,p) = (10,50)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = matrix(rnorm(10*50),ncol=50)
  }
  
  counter[i] = ifelse(meank.2019CPH(mylist)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'meank.2019CPH'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{cao_test_2019}{SHT}
}
