% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqdist.2014BG.R
\name{eqdist.2014BG}
\alias{eqdist.2014BG}
\title{Test for Equality of Two Distributions by Biswas and Ghosh (2014)}
\usage{
eqdist.2014BG(X, Y, method = c("asymptotic", "permutation"),
  nreps = 2000)
}
\arguments{
\item{X}{a vector/matrix of 1st sample.}

\item{Y}{a vector/matrix of 2nd sample.}

\item{method}{method to compute \eqn{p}-value. Using initials is possible, \code{"p"} for permutation tests. Case insensitive.}

\item{nreps}{the number of permutations to be run when \code{method="permutation"}.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two samples (either univariate or multivariate) \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : F_X = F_Y\quad vs\quad H_1 : F_X \neq F_Y}
using the procedure by Biswas and Ghosh (2014) in a nonparametric way based on 
pairwise distance measures. Both asymptotic and permutation-based determination of 
\eqn{p}-values are supported.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
smallY = matrix(rnorm(10*3),ncol=3)
eqdist.2014BG(smallX, smallY) # run the test

\donttest{
## compare asymptotic and permutation-based powers
set.seed(777)
ntest  = 1000
pval.a = rep(0,ntest)
pval.p = rep(0,ntest)

for (i in 1:ntest){
  x = matrix(rnorm(100), nrow=5)
  y = matrix(rnorm(100), nrow=5)
  
  pval.a[i] = ifelse(eqdist.2014BG(x,y,method="a")$p.value<0.05,1,0)
  pval.p[i] = ifelse(eqdist.2014BG(x,y,method="p",nreps=100)$p.value <0.05,1,0)
}

## print the result
cat(paste(
sprintf("\\n* EMPIRICAL TYPE 1 ERROR COMPARISON \\n"),
sprintf("* Asymptotics :  \%.3f\\n", sum(pval.a/ntest)),
sprintf("* Permutation :  \%.3f\\n", sum(pval.p/ntest)),sep=""))
}

}
\references{
\insertRef{biswas_nonparametric_2014}{SHT}
}
