% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphID.R
\name{graphID.main}
\alias{graphID.main}
\title{Helper function to handle a graph component.}
\usage{
graphID.main(
  L,
  O,
  test.globalID = TRUE,
  test.genericID = TRUE,
  test.nonID = TRUE
)
}
\arguments{
\item{L}{Adjacency matrix for the directed part of the path
diagram/mixed graph; an edge pointing from i to j is encoded as L[i,j]=1 and
the lack of an edge between i and j is encoded as L[i,j]=0. There should be
no directed self loops, i.e. no i such that L[i,i]=1.}

\item{O}{Adjacency matrix for the bidirected part of the path diagram/mixed
graph. Edges are encoded as for the L parameter. Again there should be no
self loops. Also this matrix will be coerced to be symmetric so it is only
necessary to specify an edge once, i.e. if O[i,j]=1 you may, but are not
required to, also have O[j,i]=1.}

\item{test.globalID}{A logical value indicating whether or not global
identifiability is checked.}

\item{test.genericID}{A logical value indicating whether or not a sufficient
condition for generic identifiability is checked.}

\item{test.nonID}{A logical value indicating whether or not a condition
implying generic non-identifiability is checked.}
}
\value{
A list containing named components of the results of various tests
desired based on the input parameters.
}
\description{
Calls the other functions that determine identifiability status.
}
