% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/leerDatos.R
\name{save.keel}
\alias{save.keel}
\title{Saves a \code{keel} dataset into a KEEL dataset format file.}
\usage{
save.keel(dataset, file)
}
\arguments{
\item{dataset}{The \code{keel} object stored in R environment.}

\item{file}{The file name (or path) to save the KEEL dataset.}
}
\description{
This function exports a keel dataset stored in the R environment into a KEEL format file on the hard disk.
This function can not save information about the fuzzy
definition created by the function \link{read.keel} because the KEEL format does not
define that kind of information.
}
\details{
A KEEL data file must have the following structure:
 \itemize{
   \item{ @relation: Name of the data set }
   \item{ @attribute: Description of an attribute (one for each attribute)}
   \item{ @inputs: List with the names of the input attributes }
   \item{ @output: Name of the output attribute (Not used in this algorithms implementation) }
   \item{ @data: Starting tag of the data}
}
   The rest of the file contains all the examples belonging to the data set, expressed in comma sepparated values format.
}
\author{
Angel M. Garcia <amgv0009@red.ujaen.es>
}
\references{
J. Alcala-Fdez, A. Fernandez, J. Luengo, J. Derrac, S. Garcia, L. Sanchez, F. Herrera. KEEL Data-Mining Software Tool: Data Set Repository, Integration of Algorithms and Experimental Analysis Framework. Journal of Multiple-Valued Logic and Soft Computing 17:2-3 (2011) 255-287.
}
\seealso{
KEEL Dataset Repository (Standard Classification): \url{http://sci2s.ugr.es/keel/category.php?cat=clas}
}

