% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelReport.R
\name{modelReport}
\alias{modelReport}
\title{Model Report}
\usage{
modelReport(model, type, folder, test = NULL, response_curves = FALSE,
  jk = FALSE, env = NULL, clamp = TRUE, permut = 10)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} object.}

\item{type}{character. Output type, see \code{\link{predict,SDMmodel-method}}
for more details.}

\item{folder}{character. The name of the folder in which to save the output.
The folder is created in the working directory.}

\item{test}{\linkS4class{SWD} object with the test locations, default is
\code{NULL}.}

\item{response_curves}{logical, if \code{TRUE} it plots the response curves
in the html output, default is \code{FALSE}.}

\item{jk}{logical, if \code{TRUE} it runs the jackknife test, default
\code{FALSE}.}

\item{env}{\code{\link[raster]{stack}}. If provided it computes and adds a
prediction map to the output, default is \code{NULL}.}

\item{clamp}{logical for clumping during prediction, used for response curves
and for the prediction map, default is \code{TRUE}.}

\item{permut}{integer. Number of permutations, default is 10.}
}
\description{
Make a report that shows the main results.
}
\details{
The function produces a report similar to the one created by MaxEnt
software.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxent", p = train, a = bg, fc = "l")

# Create the report
modelReport(model, type = "cloglog", folder = "my_folder", test = test,
            response_curves = TRUE, jk = TRUE, env = predictors)
}
}
\author{
Sergio Vignali
}
