% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.SDTree}
\alias{predict.SDTree}
\title{Predictions for the SDTree}
\usage{
\method{predict}{SDTree}(object, newdata, ...)
}
\arguments{
\item{object}{Fitted object of class \code{SDTree}.}

\item{newdata}{New test data of class \code{data.frame} containing 
the covariates for which to predict the response.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector of predictions for the new data.
}
\description{
Predicts the response for new data using a fitted SDTree.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
predict(model, newdata = data.frame(X))
}
\seealso{
\code{\link{SDTree}}
}
\author{
Markus Ulmer
}
