% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter.r
\name{dupfilter}
\alias{dupfilter}
\title{Filter temporal and/or spatial duplicates}
\usage{
dupfilter(sdata, step.time = 0, step.dist = 0, conditional = FALSE)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". "DateTime" is date & time in class POSIXct. 
"lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{step.time}{A numeric vector specifying temporal interval between two consecutive locations. Default is 0 hours. 
Locations are considered temporal duplicates if the temporal interval is less than or equal to the user specified value.}

\item{step.dist}{A numeric vector specifying spatial interval between two consecutive locations. Default is 0 kilometres. 
Locations are considered spatial duplicates if the spatial interval is less than or equal to the user specified value.}

\item{conditional}{If TRUE, spatial duplicates are removed only if temporal interval between the locations is 
less than the time specified in "step.time". Default is FALSE.}
}
\value{
Input data frame is returned with spatial and temporal duplicates removed. 
The following columns are added: "pTime", "sTime", "pDist", "sDist". 
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively.
}
\description{
Function to remove temporal and/or spatial duplicates.
}
\details{
A fix associated with a higher quality index is retained over other duplicated fixes. 
If temporal duplicates are associated with same quality index, a fix located closest to a previous and a subsequent location is retained.
}
\examples{
### Load data sets
# Fastloc GPS data obtained from a green turtle
data(turtle)


### Apply dupfilter
turtle.dup <- dupfilter(turtle)
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
Marine Biology 163:1-14 doi:10.1007/s00227-015-2771-0
}
\seealso{
dupfilter.exact, dupfilter.qi, dupfilter.time, dupfilter.space
}
\author{
Takahiro Shimada
}
