% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{SDEFSR_DatasetFromDataFrame}
\alias{SDEFSR_DatasetFromDataFrame}
\title{Creates a \code{SDEFSR_Dataset} object from a \code{data.frame}}
\usage{
SDEFSR_DatasetFromDataFrame(data, relation, names = NA, types = NA,
  classNames = NA)
}
\arguments{
\item{data}{A \code{data.frame} object with all neccesary information. See details.}

\item{relation}{A string that indicate the name of the relation.}

\item{names}{An optional character vector indicating the name of the attributes.}

\item{types}{An optional character vector indicating 'c' if variable is categorical, 'r' if is real and 'e' if it is an integer}

\item{classNames}{An optional character vector indicating the values of the target class.}
}
\value{
A \code{SDEFSR_Dataset} object with all the information of the dataset.
}
\description{
Creates a \code{SDEFSR_Dataset} object from a \code{data.frame} and create fuzzy labels for numerical variables too.
}
\details{
The information of the data.frame must be stored with instances in rows and variables in columns
If you dont specify any of the optional parameter the function try to obtain them automatically. 

For \code{'names'} if it is NA, the function takes the name of the columns by \code{colnames}.

For \code{'types'} if it is NA, the function takes the type of an attribute asking the type of the column of the data.frame.
If it is \code{'character'} it is assumed that it is categorical, and if \code{'numeric'} it is assumed that it is a real number.
PLEASE, PAY ATTENTION TO THIS WAY OF WORK. It can cause tranformation errors taking a numeric variable as categorical or vice-versa.

For \code{'classNames'} if it is NA, the function returns unique values of the last attribute of the data.frame that is considered the class attribute.
}
\examples{
library(SDEFSR)
df <- data.frame(matrix(runif(1000), ncol = 10))
#Add class attribute
df[,11] <- c("0", "1", "2", "3")
SDEFSR_DatasetObject <- SDEFSR_DatasetFromDataFrame(df, "random")
invisible()

}
\author{
Angel M Garcia <amgv0009@red.ujaen.es>
}
\seealso{
\code{\link{read.dataset}}
}

