% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate_trajectory}
\alias{evaluate_trajectory}
\title{Evaluate the inferred timeline}
\usage{
evaluate_trajectory(time, progression)
}
\arguments{
\item{time}{A numeric vector containing the inferred time points of each sample along a trajectory.}

\item{progression}{A factor or a numeric vector which represents the progression stages of each sample.}
}
\value{
The consistency value for the predicted timeline.
}
\description{
\code{evaluate_trajectory} calculates the \emph{consistency} of
the predicted time points of samples versus the known progression stages.
}
\examples{
## Generate a dataset
dataset <- generate_dataset(type="s", num_genes=500, num_samples=1000, num_groups=4)
space <- reduce_dimensionality(dataset$expression, correlation_distance, ndim=2)
traj <- infer_trajectory(space)

## Evaluate the trajectory timeline
evaluate_trajectory(traj$time, dataset$sample_info$group_name)
}
