% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{get_connection}
\alias{get_connection}
\title{Opens connection to the database}
\usage{
get_connection(
  drv = RPostgres::Postgres(),
  host = NULL,
  port = NULL,
  dbname = NULL,
  user = NULL,
  password = NULL,
  timezone = NULL,
  timezone_out = NULL,
  ...
)
}
\arguments{
\item{drv}{An object that inherits from DBIDriver or an existing DBIConnection (default: RPostgres::Postgres())}

\item{host}{Character string giving the ip of the host to connect to}

\item{port}{Host port to connect to (numeric)}

\item{dbname}{Name of the database located at the host}

\item{user}{Username to login with}

\item{password}{Password to login with}

\item{timezone}{Sets the timezone of DBI::dbConnect()}

\item{timezone_out}{Sets the timezone_out of DBI::dbConnect()}

\item{...}{Additional parameters sent to DBI::dbConnect()}
}
\value{
An object that inherits from DBIConnection driver specified in drv
}
\description{
Connects to the specified dbname of host:port using user and password from given arguments.
Certain drivers may use credentials stored in a file, such as ~/.pgpass (PostgreSQL)
}
\examples{
\dontrun{
close_connection(conn)
}

}
\seealso{
\link[RPostgres:Postgres]{RPostgres::Postgres}
}
