% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Data2020}
\alias{Data2020}
\title{Spatial dataset to replicate the results for 2020 from Cerqueti, R., Maranzano, P. & Mattera, R. "Spatially-clustered spatial autoregressive models with application to agricultural market concentration in Europe". arXiv preprints (<https://doi.org/10.48550/arXiv.2407.15874>)}
\format{
\describe{
\code{Data2020} is a data frame with 222 rows, 13 variables and a geometry representing the regions' polygons:
\item{Year}{Reference year for the data, that is, 2020}
\item{geo_lab}{Extended name (English-translated) of the regions}
\item{geo}{Eurostat NUTS-2 code of the regions}
\item{Gini_SO}{Gini index for the standard output of farms and agricultural holdings in each region}
\item{GDPPC_PPS2020}{Regional per capita GDP measured as Euros PPS 2020}
\item{Share_AgroEmp}{Share of employment in agriculture: relevance of agricultural industry on the regional labor market}
\item{HoursWorked_AgroEmp}{Hours worked per agro-employed: agricultural labor market intensity}
\item{GVA_AgroEmp}{Gross value added per agro-employed: agricultural productivity intensity}
\item{GFCF_AgroEmp}{Investment per agro-employed: propensity to invest according to the economic size}
\item{Share_AgroGVA}{Share of agricultural GVA on total GVA: relevance of agricultural industry on the regional economy}
\item{Share_AgroLand}{Share of agricultural land: relevance of agricultural industry on the regional activities}
\item{Alt_mean}{Average altitude: geography and landscape}
\item{HDD}{Heating degree days (HDD): proxy of temperature and weather conditions}
}
}
\source{
{
Eurostat -- Economic accounts for agriculture by NUTS 2 region' (agr_r_accts, DOI:10.2908/agr_r_accts)
}
}
\usage{
data(Data_RC_PM_RM_JABES2024)
}
\description{
The 'Data_RC_PM_RM_JABES2024' dataset was created merging information from the Eurostat regional database (<https://ec.europa.eu/eurostat/web/regions/database>).
it is a spatial dataset to replicate the results for 2020 from Cerqueti, R., Maranzano, P. & Mattera, R. "Spatially-clustered spatial autoregressive models with application to agricultural market concentration in Europe". arXiv preprints (<https://doi.org/10.48550/arXiv.2407.15874>).
Data contained in this file refer to the agricultural sector industry for 222 European regions (NUTS-2 classification) for 2020.
For more information see the database 'Economic accounts for agriculture by NUTS 2 region' (agr_r_accts, DOI:10.2908/agr_r_accts).
The file includes 6 mixed-type objects:
}
\note{
{
All source data files prepared by Paolo Maranzano (Department of Economics, Management and Statistics, University of Milano-Bicocca, Italy).
}
}
\keyword{datasets}
