% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SADISA_ML.R
\name{SADISA_ML}
\alias{SADISA_ML}
\title{Performs maximum likelihood parameter estimation for requested model}
\usage{
SADISA_ML(abund, initpars, labelpars, model = c("pm", "dl"), mult = "mg",
  tol = c(1e-06, 1e-06, 1e-06), maxiter = 1000 *
  round((1.25)^length(which(labelpars == 1))), optimmethod = "subplex")
}
\arguments{
\item{abund}{abundance vector or a list of abundance vectors.
When a list is provided and mult = 'mg' (the default), it is assumed that the different vectors
apply to different guilds. When mult = 'ms' then the different vectors apply to multiple samples.
from the same metacommunity. In this case the vectors should have equal lengths and may contain
zeros because there may be species that occur in multiple samples and species that do not occur
in some of the samples.}

\item{initpars}{a vector, or - when there are multiple samples or multiple guilds - a matrix of parameter values}

\item{labelpars}{a vector, or - when there are multiple samples or multiple guilds - a matrix indicating whether the parameters
in initpars must remain fixed (0) during optimization, optimized (1), or - in the case of multiple samples or guilds - set equal
to the parameter of the first sample/guild (2).}

\item{model}{the chosen combination of metacommunity model and local community model
as a vector, e.g. c('pm','dl') for a model with point mutation in the metacommunity and
dispersal limitation.
The choices for the metacommunity model are: 'pm' (point mutation), 'rf' (random fission),
'pr' (protracted speciation), 'dd' (density-dependence).
The choices for the local community model are: 'dl' (dispersal limitation), 'dd' (density-dependence).}

\item{mult}{When set to 'mg' (the default) the loglikelihood for multiple guilds is computed.
When set to 'ms' the loglikelihood for multiple samples from the same metacommunity is computed.}

\item{tol}{a vector containing three numbers for the relative tolerance in the parameters, the relative tolerance in the function, and the absolute tolerance in the parameters.}

\item{maxiter}{sets the maximum number of iterations}

\item{optimmethod}{sets the optimization method to be used, either subplex (default) or an alternative implementation of simplex.}
}
\description{
Computes maximum loglikelihood and corresponding parameters for the requested model using the independent-species approach.
For optimization it uses various auxiliary functions in the DDD package.
}
\details{
Not all combinations of metacommunity model and local community model have been implemented yet.
because this requires checking for numerical stability of the integration. The currently available model combinations are, for a single sample, c('pm','dl'), c('pm','rf'), c('dd','dl'),
c('pr','dl'), c('pm','dd'), and for multiple samples, c('pm','dl').
}
\examples{
utils::data(datasets);
utils::data(fitresults);
result <- SADISA_ML(
   abund = datasets$dset1.abunvec[[1]],
   initpars = fitresults$fit1a.parsopt[[1]],
   labelpars = c(1,1),
   model = c('pm','dl'),
   tol = c(1E-1, 1E-1, 1E-1)
   );
# Note that tolerances should be set much lower than 1E-1 to get the best results.
}
\references{
Haegeman, B. & Etienne, R.S. (2016). A general sampling formula for community abundance data. Methods in Ecology & Evolution. In review.
}
\keyword{model}
\keyword{species-abundance-distribution}

