% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxJacobian.R
\name{rxExpandGrid}
\alias{rxExpandGrid}
\title{Faster expand.grid}
\usage{
rxExpandGrid(x, y, type = 0L)
}
\arguments{
\item{x}{first element (must be character)}

\item{y}{second element (must be character)}

\item{type}{Internal type=0L is traditional expand grid and
type=1L is jacobian expand grid (adds symbols)}
}
\value{
Expand grid
}
\description{
Only support x and y as characters right now
}
\examples{

##
rxExpandGrid(letters, letters)

## Another fast method; See
## https://stackoverflow.com/questions/10405637/use-outer-instead-of-expand-grid

expand.grid.jc <- function(seq1,seq2) {
 cbind(Var1 = rep.int(seq1, length(seq2)),
  Var2 = rep.int(seq2, rep.int(length(seq1),length(seq2))))
}

\donttest{
 microbenchmark::microbenchmark(rxExpandGrid(letters, letters), expand.grid.jc(letters, letters))
}
}
\author{
Matthew Fidler
}
\keyword{internal}
