require(RxODE);

rxPermissive({

    for (radi in 1:3){

        rxUseRadixSort(switch(radi, FALSE, TRUE, TRUE));
        RxODE:::forderForceBase(switch(radi, FALSE, TRUE, FALSE))
        radix <- switch(radi, "timsort", "base::order", "data.table::forder")
        context(sprintf("etTrans checks (radix: %s)", radix));
        rxSetIni0(FALSE)
        mod <- RxODE("
a = 6
b = 0.6
d/dt(intestine) = -a*intestine
d/dt(blood)     = a*intestine - b*blood
")

        et <- eventTable()
        et$add.dosing(dose=2/24,rate=2,start.time=0,
                      nbr.doses=10,dosing.interval=1)
        et <- et %>% et(0.05,evid=2) %>%
            et(amt=3,time=0.5,cmt=out) %>%
            et(amt=3,time=0.1,cmt=intestine,ss=1,ii=3) %>%
            et(amt=3,time=0.3,cmt=intestine,ss=2,ii=3) %>%
            et(time=0.2,cmt="-intestine") %>%
            as.data.frame

        test_that("error for empty data",{
            expect_error(suppressWarnings({RxODE:::etTrans(et, mod)}));
        })

        ett1 <- RxODE:::etTrans(et, mod, keepDosingOnly=TRUE)
        tmp1 <- sort(unique(ett1$EVID));

        et$cmt <- factor(et$cmt)
        ett2 <- RxODE:::etTrans(et, mod, keepDosingOnly=TRUE);


        test_that("factor and character give same compartment information",{
            expect_equal(attr(class(ett2), ".RxODE.lst")$cmtInfo, attr(class(ett1), ".RxODE.lst")$cmtInfo);
            expect_equal(attr(class(ett2), ".RxODE.lst")$cmtInfo, c("intestine", "blood", "out"))
        })

        test_that("factor and character give same evids",{
            expect_equal(ett1$EVID,ett2$EVID);
        })

        et0  <- et;

        et$cmt  <- paste(et$cmt);
        et$cmt[1:2]  <- NA_character_

        ett1 <- RxODE::etTrans(et, mod, keepDosingOnly=TRUE, addCmt=TRUE);

        test_that("string NA gives 1 for default compartment",{
            expect_equal(ett1$EVID,ett2$EVID)
        })

        et  <- et0;
        et$cmt[1:2]  <- NA_integer_
        ett2 <- RxODE:::etTrans(et, mod, keepDosingOnly=TRUE, addCmt=TRUE);

        test_that("factor NA gives 1 for default compartment",{
            expect_equal(ett2$EVID,ett1$EVID)
        })

        et$cmt  <- as.integer(et$cmt)

        et$cmt[1:2]  <- NA_integer_

        ett2 <- RxODE:::etTrans(et, mod, keepDosingOnly=TRUE, addCmt=TRUE);

        test_that("factor NA gives 1 for default compartment",{
            expect_equal(ett2$EVID[1:2],ett1$EVID[1:2])
        })

        et <- eventTable()
        et$add.dosing(dose=2/24,rate=2,start.time=0,
                      nbr.doses=10,dosing.interval=1)
        et <- et %>% et(0.05,evid=2) %>%
            et(amt=3,time=0.5,cmt="-out") %>% as.data.frame

        test_that("error for negative non ODE compartments",{
            expect_error(RxODE:::etTrans(et, mod, keepDosingOnly=TRUE))
            et$cmt <- factor(et$cmt)
            expect_error(RxODE:::etTrans(et, mod, keepDosingOnly=TRUE))
        })

        et <- eventTable()
        et$add.dosing(dose=2/24,rate=2,start.time=0,
                      nbr.doses=10,dosing.interval=1)
        et <- et %>% et(0.05,evid=2) %>%
            et(amt=3,time=0.25,cmt="out") %>%
            et(amt=3,time=0.5,cmt="-out") %>% as.data.frame

        test_that("error for negative non ODE compartments after defined compartment", {
            expect_error(RxODE:::etTrans(et, mod, keepDosingOnly=TRUE))
            et$cmt <- factor(et$cmt)
            expect_error(RxODE:::etTrans(et, mod, keepDosingOnly=TRUE))
        })

        et <- et() %>% et(amt=3,time=0.24,evid=4)

        test_that("EVID=4 makes sense", {
            expect_equal(expect_warning(RxODE:::etTrans(et, mod, keepDosingOnly=TRUE)$EVID), c(3L, 101L))
        })


        mod <- RxODE("    CO = (187 * WT^0.81) * 60/1000
    QHT = 4 * CO/100
    QBR = 12 * CO/100
    QMU = 17 * CO/100
    QAD = 5 * CO/100
    QSK = 5 * CO/100
    QSP = 3 * CO/100
    QPA = 1 * CO/100
    QLI = 25.5 * CO/100
    QST = 1 * CO/100
    QGU = 14 * CO/100
    QHA = QLI - (QSP + QPA + QST + QGU)
    QBO = 5 * CO/100
    QKI = 19 * CO/100
    QRB = CO - (QHT + QBR + QMU + QAD + QSK + QLI + QBO + QKI)
    QLU = QHT + QBR + QMU + QAD + QSK + QLI + QBO + QKI + QRB
    VLU = (0.76 * WT/100)/1.051
    VHT = (0.47 * WT/100)/1.03
    VBR = (2 * WT/100)/1.036
    VMU = (40 * WT/100)/1.041
    VAD = (21.42 * WT/100)/0.916
    VSK = (3.71 * WT/100)/1.116
    VSP = (0.26 * WT/100)/1.054
    VPA = (0.14 * WT/100)/1.045
    VLI = (2.57 * WT/100)/1.04
    VST = (0.21 * WT/100)/1.05
    VGU = (1.44 * WT/100)/1.043
    VBO = (14.29 * WT/100)/1.99
    VKI = (0.44 * WT/100)/1.05
    VAB = (2.81 * WT/100)/1.04
    VVB = (5.62 * WT/100)/1.04
    VRB = (3.86 * WT/100)/1.04
    BP = 0.61
    fup = 0.028
    fub = fup/BP
    KbLU = exp(0.8334)
    KbHT = exp(1.1205)
    KbSK = exp(-0.5238)
    KbSP = exp(0.3224)
    KbPA = exp(0.3224)
    KbLI = exp(1.7604)
    KbST = exp(0.3224)
    KbGU = exp(1.2026)
    KbKI = exp(1.3171)
    S15 = VVB * BP/1000
    C15 = Venous_Blood/S15
    lnC15 = log(C15)
    d/dt(Lungs) = QLU * (Venous_Blood/VVB - Lungs/KbLU/VLU)
    d/dt(Heart) = QHT * (Arterial_Blood/VAB - Heart/KbHT/VHT)
    d/dt(Brain) = QBR * (Arterial_Blood/VAB - Brain/KbBR/VBR)
    d/dt(Muscles) = QMU * (Arterial_Blood/VAB - Muscles/KbMU/VMU)
    d/dt(Adipose) = QAD * (Arterial_Blood/VAB - Adipose/KbAD/VAD)
    d/dt(Skin) = QSK * (Arterial_Blood/VAB - Skin/KbSK/VSK)
    d/dt(Spleen) = QSP * (Arterial_Blood/VAB - Spleen/KbSP/VSP)
    d/dt(Pancreas) = QPA * (Arterial_Blood/VAB - Pancreas/KbPA/VPA)
    d/dt(Liver) = QHA * Arterial_Blood/VAB + QSP * Spleen/KbSP/VSP + QPA * Pancreas/KbPA/VPA + QST * Stomach/KbST/VST + QGU * Gut/KbGU/VGU - CLint * fub * Liver/KbLI/VLI - QLI * Liver/KbLI/VLI
    d/dt(Stomach) = QST * (Arterial_Blood/VAB - Stomach/KbST/VST)
    d/dt(Gut) = QGU * (Arterial_Blood/VAB - Gut/KbGU/VGU)
    d/dt(Bones) = QBO * (Arterial_Blood/VAB - Bones/KbBO/VBO)
    d/dt(Kidneys) = QKI * (Arterial_Blood/VAB - Kidneys/KbKI/VKI)
    d/dt(Arterial_Blood) = QLU * (Lungs/KbLU/VLU - Arterial_Blood/VAB)
    d/dt(Venous_Blood) = QHT * Heart/KbHT/VHT + QBR * Brain/KbBR/VBR + QMU * Muscles/KbMU/VMU + QAD * Adipose/KbAD/VAD + QSK * Skin/KbSK/VSK + QLI * Liver/KbLI/VLI + QBO * Bones/KbBO/VBO + QKI * Kidneys/KbKI/VKI + QRB * Rest_of_Body/KbRB/VRB - QLU * Venous_Blood/VVB
    d/dt(Rest_of_Body) = QRB * (Arterial_Blood/VAB - Rest_of_Body/KbRB/VRB)")

        dat <- structure(list(ID = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                     1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                     2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,
                                     3L, 3L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L, 4L,
                                     4L, 4L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L, 5L,
                                     5L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 6L, 7L,
                                     7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 7L, 8L, 8L,
                                     8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 8L, 9L, 9L, 9L, 9L, 9L,
                                     9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 9L, 10L, 10L, 10L, 10L, 10L,
                                     10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 10L, 11L, 11L, 11L, 11L,
                                     11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 11L, 12L, 12L,
                                     12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 12L, 13L,
                                     13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L, 13L,
                                     14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L, 14L,
                                     14L, 14L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L, 15L,
                                     15L, 15L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L, 16L,
                                     16L, 16L, 16L, 16L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L, 17L,
                                     17L, 17L, 17L, 17L, 17L, 17L, 18L, 18L, 18L, 18L, 18L, 18L, 18L,
                                     18L, 18L, 18L, 18L, 18L, 18L, 18L, 19L, 19L, 19L, 19L, 19L, 19L,
                                     19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L, 19L), CMT = c(15, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                                                                           1, 1, 1, 1, 15, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 15, 1,
                                                                                           1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1), EVID = c(1501, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            0, 0, 0, 0, 0, 0, 1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                            1501, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), EVI2 = c(1L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                      0L, 0L), MDV = c(1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                       0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), DV = c(0, 6.196, 6.405, 6.321,
                                                                                                                                                                                                                                                               5.737, 5.468, 4.99, 4.615, 4.282, 3.963, 3.547, 3.526, 3.199,
                                                                                                                                                                                                                                                               2.646, 1.984, 1.374, 0, 6.553, 6.129, 6.016, 5.714, 5.529, 5.293,
                                                                                                                                                                                                                                                               4.516, 4.159, 4.009, 3.894, 3.49, 2.747, 1.904, 0, 5.714, 5.903,
                                                                                                                                                                                                                                                               5.924, 5.846, 5.714, 5.063, 4.439, 4.253, 3.942, 3.638, 3.589,
                                                                                                                                                                                                                                                               2.639, 1.591, 0, 6.035, 5.82, 5.727, 5.352, 5.242, 4.673, 4.227,
                                                                                                                                                                                                                                                               3.648, 3.378, 3.281, 3.219, 2.803, 2.262, 1.364, 0.7324, 0, 6.601,
                                                                                                                                                                                                                                                               6.42, 6.098, 5.979, 5.883, 5.231, 4.533, 4.127, 3.961, 4.214,
                                                                                                                                                                                                                                                               3.993, 3.723, 2.653, 1.699, 0, 5.521, 5.533, 5.924, 5.943, 5.966,
                                                                                                                                                                                                                                                               5.394, 5.273, 4.615, 4.224, 3.764, 3.658, 2.862, 1.647, 0, 6.384,
                                                                                                                                                                                                                                                               6.344, 6.244, 6.019, 5.826, 5.442, 4.682, 4.382, 4.127, 3.658,
                                                                                                                                                                                                                                                               3.414, 2.96, 2.182, 1.044, 0, 6.19, 6.375, 6.34, 6.071, 5.787,
                                                                                                                                                                                                                                                               5.106, 4.426, 4.091, 3.378, 3.45, 2.981, 1.749, 0, 6.893, 6.627,
                                                                                                                                                                                                                                                               6.512, 6.229, 5.976, 5.165, 4.868, 4.315, 4.078, 3.904, 3.648,
                                                                                                                                                                                                                                                               2.976, 1.685, 0, 5.595, 5.673, 5.58, 5.529, 5.497, 5.303, 4.58,
                                                                                                                                                                                                                                                               3.934, 3.547, 3.25, 2.907, 2.129, 1.338, 0, 6.064, 6.071, 6.052,
                                                                                                                                                                                                                                                               6.023, 5.805, 5.288, 4.71, 4.355, 3.924, 3.353, 3.178, 2.695,
                                                                                                                                                                                                                                                               1.939, 1.418, 0, 5.869, 5.743, 5.733, 5.829, 5.342, 5.142, 4.663,
                                                                                                                                                                                                                                                               4.024, 3.844, 3.246, 3.161, 2.542, 0.6981, 0, 5.943, 6.19, 5.872,
                                                                                                                                                                                                                                                               5.805, 5.68, 5.38, 4.388, 4.104, 3.798, 3.714, 3.592, 2.944,
                                                                                                                                                                                                                                                               1.564, 0, 5.886, 5.74, 5.587, 5.421, 5.361, 4.86, 4.426, 3.888,
                                                                                                                                                                                                                                                               3.661, 3.716, 3.813, 2.96, 2.534, 1.647, 0, 5.583, 5.861, 5.823,
                                                                                                                                                                                                                                                               5.631, 5.905, 5.136, 4.601, 4.164, 3.493, 3.231, 2.477, 1.426,
                                                                                                                                                                                                                                                               0, 6.506, 6.1, 6.203, 5.894, 5.869, 5.069, 4.828, 4.308, 4.048,
                                                                                                                                                                                                                                                               3.17, 3.219, 2.526, 2.276, 0.9632, 0, 6.198, 6.016, 5.852, 5.666,
                                                                                                                                                                                                                                                               5.176, 4.654, 4.157, 3.784, 3.343, 3.227, 2.342, 2.241, 1.437,
                                                                                                                                                                                                                                                               0.7467, 0, 6.178, 6.078, 6.304, 6.186, 5.73, 5.656, 5.063, 4.549,
                                                                                                                                                                                                                                                               4.079, 3.353, 3.456, 2.442, 1.721, 0, 6.31, 6.409, 6.155, 6.021,
                                                                                                                                                                                                                                                               5.677, 4.997, 4.234, 4.086, 3.648, 3.447, 3.735, 2.809, 2.272,
                                                                                                                                                                                                                                                               0.8587), LNDV = c(0, 6.196, 6.405, 6.321, 5.737, 5.468, 4.99,
                                                                                                                                                                                                                                                                                 4.615, 4.282, 3.963, 3.547, 3.526, 3.199, 2.646, 1.984, 1.374,
                                                                                                                                                                                                                                                                                 0, 6.553, 6.129, 6.016, 5.714, 5.529, 5.293, 4.516, 4.159, 4.009,
                                                                                                                                                                                                                                                                                 3.894, 3.49, 2.747, 1.904, 0, 5.714, 5.903, 5.924, 5.846, 5.714,
                                                                                                                                                                                                                                                                                 5.063, 4.439, 4.253, 3.942, 3.638, 3.589, 2.639, 1.591, 0, 6.035,
                                                                                                                                                                                                                                                                                 5.82, 5.727, 5.352, 5.242, 4.673, 4.227, 3.648, 3.378, 3.281,
                                                                                                                                                                                                                                                                                 3.219, 2.803, 2.262, 1.364, 0.7324, 0, 6.601, 6.42, 6.098, 5.979,
                                                                                                                                                                                                                                                                                 5.883, 5.231, 4.533, 4.127, 3.961, 4.214, 3.993, 3.723, 2.653,
                                                                                                                                                                                                                                                                                 1.699, 0, 5.521, 5.533, 5.924, 5.943, 5.966, 5.394, 5.273, 4.615,
                                                                                                                                                                                                                                                                                 4.224, 3.764, 3.658, 2.862, 1.647, 0, 6.384, 6.344, 6.244, 6.019,
                                                                                                                                                                                                                                                                                 5.826, 5.442, 4.682, 4.382, 4.127, 3.658, 3.414, 2.96, 2.182,
                                                                                                                                                                                                                                                                                 1.044, 0, 6.19, 6.375, 6.34, 6.071, 5.787, 5.106, 4.426, 4.091,
                                                                                                                                                                                                                                                                                 3.378, 3.45, 2.981, 1.749, 0, 6.893, 6.627, 6.512, 6.229, 5.976,
                                                                                                                                                                                                                                                                                 5.165, 4.868, 4.315, 4.078, 3.904, 3.648, 2.976, 1.685, 0, 5.595,
                                                                                                                                                                                                                                                                                 5.673, 5.58, 5.529, 5.497, 5.303, 4.58, 3.934, 3.547, 3.25, 2.907,
                                                                                                                                                                                                                                                                                 2.129, 1.338, 0, 6.064, 6.071, 6.052, 6.023, 5.805, 5.288, 4.71,
                                                                                                                                                                                                                                                                                 4.355, 3.924, 3.353, 3.178, 2.695, 1.939, 1.418, 0, 5.869, 5.743,
                                                                                                                                                                                                                                                                                 5.733, 5.829, 5.342, 5.142, 4.663, 4.024, 3.844, 3.246, 3.161,
                                                                                                                                                                                                                                                                                 2.542, 0.6981, 0, 5.943, 6.19, 5.872, 5.805, 5.68, 5.38, 4.388,
                                                                                                                                                                                                                                                                                 4.104, 3.798, 3.714, 3.592, 2.944, 1.564, 0, 5.886, 5.74, 5.587,
                                                                                                                                                                                                                                                                                 5.421, 5.361, 4.86, 4.426, 3.888, 3.661, 3.716, 3.813, 2.96,
                                                                                                                                                                                                                                                                                 2.534, 1.647, 0, 5.583, 5.861, 5.823, 5.631, 5.905, 5.136, 4.601,
                                                                                                                                                                                                                                                                                 4.164, 3.493, 3.231, 2.477, 1.426, 0, 6.506, 6.1, 6.203, 5.894,
                                                                                                                                                                                                                                                                                 5.869, 5.069, 4.828, 4.308, 4.048, 3.17, 3.219, 2.526, 2.276,
                                                                                                                                                                                                                                                                                 0.9632, 0, 6.198, 6.016, 5.852, 5.666, 5.176, 4.654, 4.157, 3.784,
                                                                                                                                                                                                                                                                                 3.343, 3.227, 2.342, 2.241, 1.437, 0.7467, 0, 6.178, 6.078, 6.304,
                                                                                                                                                                                                                                                                                 6.186, 5.73, 5.656, 5.063, 4.549, 4.079, 3.353, 3.456, 2.442,
                                                                                                                                                                                                                                                                                 1.721, 0, 6.31, 6.409, 6.155, 6.021, 5.677, 4.997, 4.234, 4.086,
                                                                                                                                                                                                                                                                                 3.648, 3.447, 3.735, 2.809, 2.272, 0.8587), AMT = c(25, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37.5, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 37.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     37.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37.5, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 37.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 37.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37.5,
                                                                                                                                                                                                                                                                                                                                     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), TIME = c(0, 0.2, 0.25,
                                                                                                                                                                                                                                                                                                                                                                                         0.367, 0.533, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2,
                                                                                                                                                                                                                                                                                                                                                                                         36.167, 48.167, 0, 0.2, 0.25, 0.367, 0.533, 0.7, 1.2, 2.2, 3.233,
                                                                                                                                                                                                                                                                                                                                                                                         4.2, 6.2, 8.25, 12.2, 24.2, 0, 0.2, 0.25, 0.367, 0.533, 0.7,
                                                                                                                                                                                                                                                                                                                                                                                         1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 0, 0.2, 0.25, 0.367,
                                                                                                                                                                                                                                                                                                                                                                                         0.533, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.267, 12.2, 24.2, 36.35,
                                                                                                                                                                                                                                                                                                                                                                                         48.167, 0, 0.233, 0.25, 0.367, 0.533, 0.7, 1.233, 2.2, 3.2, 4.2,
                                                                                                                                                                                                                                                                                                                                                                                         6.2, 8.2, 12.283, 24.2, 36.167, 0, 0.2, 0.25, 0.367, 0.533, 0.7,
                                                                                                                                                                                                                                                                                                                                                                                         1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.233, 24.2, 0, 0.2, 0.25, 0.4,
                                                                                                                                                                                                                                                                                                                                                                                         0.533, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 36.167,
                                                                                                                                                                                                                                                                                                                                                                                         0, 0.2, 0.317, 0.417, 0.583, 0.7, 1.2, 2.417, 3.2, 4.2, 6.3,
                                                                                                                                                                                                                                                                                                                                                                                         8.35, 12.2, 0, 0.2, 0.25, 0.367, 0.533, 0.7, 1.2, 2.2, 3.2, 4.2,
                                                                                                                                                                                                                                                                                                                                                                                         6.2, 8.2, 12.2, 24.2, 0, 0.2, 0.25, 0.367, 0.533, 0.7, 1.2, 2.2,
                                                                                                                                                                                                                                                                                                                                                                                         3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 0, 0.2, 0.25, 0.367, 0.533, 0.7,
                                                                                                                                                                                                                                                                                                                                                                                         1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 36.167, 0, 0.2, 0.25,
                                                                                                                                                                                                                                                                                                                                                                                         0.367, 0.583, 0.733, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2,
                                                                                                                                                                                                                                                                                                                                                                                         0, 0.25, 0.283, 0.367, 0.533, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2,
                                                                                                                                                                                                                                                                                                                                                                                         12.2, 24.2, 0, 0.2, 0.25, 0.367, 0.533, 0.7, 1.2, 2.2, 3.2, 4.2,
                                                                                                                                                                                                                                                                                                                                                                                         6.233, 8.283, 12.233, 24.2, 36.167, 0, 0.333, 0.417, 0.533, 0.7,
                                                                                                                                                                                                                                                                                                                                                                                         1.2, 2.2, 3.2, 4.2, 6.2, 8.25, 12.2, 24.2, 0, 0.2, 0.25, 0.367,
                                                                                                                                                                                                                                                                                                                                                                                         0.533, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 36.167,
                                                                                                                                                                                                                                                                                                                                                                                         0, 0.2, 0.333, 0.667, 0.7, 1.2, 2.2, 3.2, 4.2, 6.2, 8.2, 12.2,
                                                                                                                                                                                                                                                                                                                                                                                         24.2, 36.167, 48.167, 0, 0.2, 0.25, 0.367, 0.533, 0.7, 1.2, 2.2,
                                                                                                                                                                                                                                                                                                                                                                                         3.2, 4.2, 6.2, 8.2, 12.2, 24.2, 0, 0.233, 0.283, 0.367, 0.533,
                                                                                                                                                                                                                                                                                                                                                                                         0.7, 1.2, 2.2, 3.2, 4.2, 6.233, 8.2, 12.2, 24.2, 36.167), DOSE = c(25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                            37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5, 37.5
                                                                                                                                                                                                                                                                                                                                                                                                                                                            ), OCC = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       1L, 1L, 1L, 1L, 1L, 1L), RATE = c(75L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 150L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 225L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 225L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 225L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 225L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 225L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 225L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 225L, 0L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L), AGE = c(42L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L, 42L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      42L, 42L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L, 24L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      24L, 24L, 24L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L, 31L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      31L, 31L, 31L, 31L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      46L, 46L, 46L, 46L, 46L, 46L, 46L, 41L, 41L, 41L, 41L, 41L, 41L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 27L, 27L, 27L, 27L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 27L, 23L, 23L, 23L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 20L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 20L, 23L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L, 23L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L, 28L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      28L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      46L, 46L, 46L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L, 22L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      22L, 22L, 22L, 22L, 43L, 43L, 43L, 43L, 43L, 43L, 43L, 43L, 43L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      43L, 43L, 43L, 43L, 43L, 50L, 50L, 50L, 50L, 50L, 50L, 50L, 50L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      50L, 50L, 50L, 50L, 50L, 50L, 50L, 19L, 19L, 19L, 19L, 19L, 19L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      19L, 19L, 19L, 19L, 19L, 19L, 19L, 26L, 26L, 26L, 26L, 26L, 26L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L, 26L, 39L, 39L, 39L, 39L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      39L, 39L, 39L, 39L, 39L, 39L, 39L, 39L, 39L, 39L, 39L, 46L, 46L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 46L, 41L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L, 41L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      41L), SEX = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1L, 1L, 1L, 1L, 1L, 1L, 1L), RACE = c(2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 88L, 88L, 88L, 88L, 88L, 88L, 88L, 88L, 88L, 88L, 88L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          88L, 88L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          2L, 2L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L), WT = c(94.3, 94.3, 94.3, 94.3, 94.3, 94.3, 94.3, 94.3, 94.3,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      94.3, 94.3, 94.3, 94.3, 94.3, 94.3, 94.3, 80.4, 80.4, 80.4, 80.4,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      80.4, 80.4, 80.4, 80.4, 80.4, 80.4, 80.4, 80.4, 80.4, 80.4, 71.8,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      71.8, 71.8, 71.8, 71.8, 71.8, 71.8, 71.8, 71.8, 71.8, 71.8, 71.8,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      71.8, 71.8, 77.4, 77.4, 77.4, 77.4, 77.4, 77.4, 77.4, 77.4, 77.4,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      77.4, 77.4, 77.4, 77.4, 77.4, 77.4, 77.4, 64.3, 64.3, 64.3, 64.3,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      64.3, 64.3, 64.3, 64.3, 64.3, 64.3, 64.3, 64.3, 64.3, 64.3, 64.3,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      74.1, 74.1, 74.1, 74.1, 74.1, 74.1, 74.1, 74.1, 74.1, 74.1, 74.1,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      74.1, 74.1, 74.1, 87.9, 87.9, 87.9, 87.9, 87.9, 87.9, 87.9, 87.9,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      87.9, 87.9, 87.9, 87.9, 87.9, 87.9, 87.9, 61.9, 61.9, 61.9, 61.9,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      61.9, 61.9, 61.9, 61.9, 61.9, 61.9, 61.9, 61.9, 61.9, 65.3, 65.3,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      65.3, 65.3, 65.3, 65.3, 65.3, 65.3, 65.3, 65.3, 65.3, 65.3, 65.3,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      65.3, 103.5, 103.5, 103.5, 103.5, 103.5, 103.5, 103.5, 103.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      103.5, 103.5, 103.5, 103.5, 103.5, 103.5, 83, 83, 83, 83, 83,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 68.7, 68.7, 68.7, 68.7,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      68.7, 68.7, 68.7, 68.7, 68.7, 68.7, 68.7, 68.7, 68.7, 68.7, 64.4,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      64.4, 64.4, 64.4, 64.4, 64.4, 64.4, 64.4, 64.4, 64.4, 64.4, 64.4,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      64.4, 64.4, 69.8, 69.8, 69.8, 69.8, 69.8, 69.8, 69.8, 69.8, 69.8,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      69.8, 69.8, 69.8, 69.8, 69.8, 69.8, 86.1, 86.1, 86.1, 86.1, 86.1,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      86.1, 86.1, 86.1, 86.1, 86.1, 86.1, 86.1, 86.1, 84.5, 84.5, 84.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      84.5, 84.5, 84.5, 84.5, 84.5, 84.5, 84.5, 84.5, 84.5, 84.5, 84.5,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      84.5, 99.1, 99.1, 99.1, 99.1, 99.1, 99.1, 99.1, 99.1, 99.1, 99.1,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      99.1, 99.1, 99.1, 99.1, 99.1, 71.2, 71.2, 71.2, 71.2, 71.2, 71.2,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      71.2, 71.2, 71.2, 71.2, 71.2, 71.2, 71.2, 71.2, 82.6, 82.6, 82.6,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      82.6, 82.6, 82.6, 82.6, 82.6, 82.6, 82.6, 82.6, 82.6, 82.6, 82.6,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      82.6), HT = c(1.769997278, 1.769997278, 1.769997278, 1.769997278,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.769997278, 1.769997278, 1.769997278, 1.769997278, 1.769997278,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.769997278, 1.769997278, 1.769997278, 1.769997278, 1.769997278,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.769997278, 1.769997278, 1.759850113, 1.759850113, 1.759850113,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.759850113, 1.759850113, 1.759850113, 1.759850113, 1.759850113,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.759850113, 1.759850113, 1.759850113, 1.759850113, 1.759850113,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.759850113, 1.809847354, 1.809847354, 1.809847354, 1.809847354,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.809847354, 1.809847354, 1.809847354, 1.809847354, 1.809847354,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.809847354, 1.809847354, 1.809847354, 1.809847354, 1.809847354,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649992805, 1.649992805, 1.649992805, 1.649992805, 1.649992805,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649992805, 1.649992805, 1.649992805, 1.649992805, 1.649992805,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649992805, 1.649992805, 1.649992805, 1.649992805, 1.649992805,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649992805, 1.560052019, 1.560052019, 1.560052019, 1.560052019,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560052019, 1.560052019, 1.560052019, 1.560052019, 1.560052019,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560052019, 1.560052019, 1.560052019, 1.560052019, 1.560052019,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560052019, 1.829862247, 1.829862247, 1.829862247, 1.829862247,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.829862247, 1.829862247, 1.829862247, 1.829862247, 1.829862247,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.829862247, 1.829862247, 1.829862247, 1.829862247, 1.829862247,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.850107347, 1.850107347, 1.850107347, 1.850107347, 1.850107347,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.850107347, 1.850107347, 1.850107347, 1.850107347, 1.850107347,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.850107347, 1.850107347, 1.850107347, 1.850107347, 1.850107347,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.730095423, 1.730095423, 1.730095423, 1.730095423, 1.730095423,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.730095423, 1.730095423, 1.730095423, 1.730095423, 1.730095423,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.730095423, 1.730095423, 1.730095423, 1.649838624, 1.649838624,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649838624, 1.649838624, 1.649838624, 1.649838624, 1.649838624,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649838624, 1.649838624, 1.649838624, 1.649838624, 1.649838624,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.649838624, 1.649838624, 1.840019627, 1.840019627, 1.840019627,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.840019627, 1.840019627, 1.840019627, 1.840019627, 1.840019627,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.840019627, 1.840019627, 1.840019627, 1.840019627, 1.840019627,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.840019627, 1.779870482, 1.779870482, 1.779870482, 1.779870482,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.779870482, 1.779870482, 1.779870482, 1.779870482, 1.779870482,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.779870482, 1.779870482, 1.779870482, 1.779870482, 1.779870482,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.779870482, 1.700058154, 1.700058154, 1.700058154, 1.700058154,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.700058154, 1.700058154, 1.700058154, 1.700058154, 1.700058154,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.700058154, 1.700058154, 1.700058154, 1.700058154, 1.700058154,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560084111, 1.560084111, 1.560084111, 1.560084111, 1.560084111,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560084111, 1.560084111, 1.560084111, 1.560084111, 1.560084111,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.560084111, 1.560084111, 1.560084111, 1.560084111, 1.640057333,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.640057333, 1.640057333, 1.640057333, 1.640057333, 1.640057333,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.640057333, 1.640057333, 1.640057333, 1.640057333, 1.640057333,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.640057333, 1.640057333, 1.640057333, 1.640057333, 1.910053686,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.910053686, 1.910053686, 1.910053686, 1.910053686, 1.910053686,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.910053686, 1.910053686, 1.910053686, 1.910053686, 1.910053686,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.910053686, 1.910053686, 1.770059565, 1.770059565, 1.770059565,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.770059565, 1.770059565, 1.770059565, 1.770059565, 1.770059565,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.770059565, 1.770059565, 1.770059565, 1.770059565, 1.770059565,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.770059565, 1.770059565, 1.809981508, 1.809981508, 1.809981508,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.809981508, 1.809981508, 1.809981508, 1.809981508, 1.809981508,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.809981508, 1.809981508, 1.809981508, 1.809981508, 1.809981508,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.809981508, 1.809981508, 1.669992764, 1.669992764, 1.669992764,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.669992764, 1.669992764, 1.669992764, 1.669992764, 1.669992764,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.669992764, 1.669992764, 1.669992764, 1.669992764, 1.669992764,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.669992764, 1.830178662, 1.830178662, 1.830178662, 1.830178662,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.830178662, 1.830178662, 1.830178662, 1.830178662, 1.830178662,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.830178662, 1.830178662, 1.830178662, 1.830178662, 1.830178662,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1.830178662), occ = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L)), class = "data.frame")

        test_that("strange rate doesn't affect model",{
            expect_false(any(etTrans(dat,mod)$AMT < 0,na.rm=TRUE))
        })

        source("theoSd.R")

        d <- theoSd[,names(theoSd) != "EVID"];

        mod  <- RxODE({
            ka <- exp(tka + eta.ka)
            cl <- exp(tcl + eta.cl)
            v <- exp(tv + eta.v)
            cp <- linCmt()
        })

        t1  <- etTrans(theoSd, mod)
        t2  <- etTrans(d, mod)

        test_that("Missing evid gives the same results",{
            expect_equal(t1$ID, t2$ID)
            expect_equal(t1$TIME, t2$TIME)
            expect_equal(t1$EVID, t2$EVID)
            expect_equal(t1$AMT, t2$AMT)
            expect_equal(t1$II, t2$II)
            expect_equal(t1$DV, t2$DV)
        })

        ## Test non-standard inputs i386 errors with addl
        ## tmp <- as.data.frame(et() %>% et(amt=3,time=0.24,evid=4))
        ## for (col in c("ss", "evid", "dur", "amt", "addl","dv", "mdv", "rate", "ii")){
        ##     et  <- data.frame(col="a", tmp[,names(tmp) != col], stringsAsFactors=FALSE)
        ##     names(et)[1]  <- col
        ##     test_that(sprintf("Non-numeric inputs raise errors (%s)", col),{
        ##         expect_error(etTrans(et, mod), col)
        ##     })
        ## }

        ## Test dates
        d1 <- data.frame(DATE=c("10-1-86", "10-1-86", "10-2-86"), TIME=c("9:15", "14:40", "8:30"), stringsAsFactors=F)
        d1$DV <- 0;

        d2 <- rbind(data.frame(ID=1, d1, stringsAsFactors=F), data.frame(ID=2, d1, stringsAsFactors=F))
        d2[d2$ID == 2, "DATE"] <- gsub("^10", "11", d2[d2$ID == 2, "DATE"]);

        d3 <- d1;
        d3$DATE <- c("10-1-1986", "10-1-1986", "10-2-1986");

        d4 <- d1;
        d4$DATE <- c("10 1 1986", "10/1/86", "10-2-1986");

        test_that("DATE conversion works correctly", {
            tmp <- etTrans(d1, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d2, mod);
            expect_equal(c(0, 5.41666666666667, 23.25, 0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d3, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d4, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
        })

        ## Dat1= day month year
        d1 <- data.frame(DV=0, DAT1=c("1-10-86", "1-10-86", "2-10-86"), TIME=c("9:15", "14:40", "8:30"), stringsAsFactors=F)

        d2 <- rbind(data.frame(ID=1, d1, stringsAsFactors=F), data.frame(ID=2, d1, stringsAsFactors=F))
        d2[d2$ID == 2, "DAT1"] <- gsub("-10-", "-11-", d2[d2$ID == 2, "DAT1"]);

        d3 <- d1;
        d3$DAT1 <- c("1-10-1986", "1-10-1986", "2-10-1986");

        d4 <- d1;
        d4$DAT1 <- c("1-10-1986", "1-10-86", "2-10-1986");

        test_that("DAT1 conversion works correctly", {
            tmp <- etTrans(d1, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d2, mod);
            expect_equal(c(0, 5.41666666666667, 23.25, 0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d3, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d4, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
        })

        ## Dat2 = year month day

        d1 <- data.frame(DAT2=c("86-10-1", "86-10-1", "86-10-2"), TIME=c("9:15", "14:40", "8:30"), stringsAsFactors=F)
        d1$DV <- 0;

        d2 <- rbind(data.frame(ID=1, d1, stringsAsFactors=F), data.frame(ID=2, d1, stringsAsFactors=F))
        d2[d2$ID == 2, "DAT2"] <- gsub("-10-", "-11-", d2[d2$ID == 2, "DAT2"]);

        d3 <- d1;
        d3$DAT2 <- c("1986-10-1", "1986-10-1", "1986-10-2");

        d4 <- d1;
        d4$DAT2 <- c("1986-10-1", "86-10-1", "1986-10-2");

        test_that("DAT2 conversion works correctly", {
            tmp <- etTrans(d1, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d2, mod);
            expect_equal(c(0, 5.41666666666667, 23.25, 0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d3, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d4, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
        })

        ## DAT3 conversion
        d1 <- data.frame(DAT3=c("86-1-10", "86-1-10", "86-2-10"), TIME=c("9:15", "14:40", "8:30"), stringsAsFactors=F)
        d1$DV <- 0;

        d2 <- rbind(data.frame(ID=1, d1, stringsAsFactors=F), data.frame(ID=2, d1, stringsAsFactors=F))
        d2[d2$ID == 2, "DAT3"] <- gsub("-10$", "-11", d2[d2$ID == 2, "DAT3"]);

        d3 <- d1;
        d3$DAT3 <- c("1986-1-10", "1986-1-10", "1986-2-10");

        d4 <- d1;
        d4$DAT3 <- c("1986-1-10", "86-1-10", "1986-2-10");

        test_that("DAT3 conversion works correctly", {
            tmp <- etTrans(d1, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d2, mod);
            expect_equal(c(0, 5.41666666666667, 23.25, 0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d3, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
            tmp <- etTrans(d4, mod);
            expect_equal(c(0, 5.41666666666667, 23.25), tmp$TIME)
        })

        d1 <- data.frame(DV=0, DATE=c("10-1-86", "10-1-86", "10-2-86"), TIME=c("9:15", "14:40", "8:30"), stringsAsFactors=F)

        d2 <- d1;
        d2$DAT1 <- d2$DATE

        d3 <- d1;
        d3$DAT2 <- d3$DATE

        d4 <- d1;
        d4$DAT3 <- d4$DATE

        test_that("Multiple DATE errors", {
            expect_error(etTrans(d2, mod))
            expect_error(etTrans(d3, mod))
            expect_error(etTrans(d4, mod))
        })


        d1 <- data.frame(DV=0, DATE=c("10-1-86", "10-1-86", "10-2-86"), TIME=c("9.15", "14:40", "8:30"), stringsAsFactors=F)

        test_that("Bad Date/Time combination", {
            expect_error(etTrans(d1, mod))
        })

        ## Test mixed classic RxODE and NONMEM inputs
        context("Mix RxODE EVIDs and NONMEM EVIDs")
        test_that("mixed EVID/data gives a warning", {
            mod <- RxODE({
                d1 <- exp(td1 + eta.d1)
                cl <- exp(tcl + eta.cl)
                d/dt(center) = - cl / v * center
                dur(center) = d1
                cp = center / v
            })


            d <- structure(list(ID = c(1L, 1L, 1L), TIME = c(0, 0, 0.25),
                                DV = c(0, 0.74, 2.84),
                                AMT = c(319.992, 0, 0), EVID = c(101L, 0L, 0L),
                                WT = c(79.6, 79.6, 79.6), RATE = c(-2, 0, 0)),
                           row.names = c(NA, 3L), class = "data.frame")

            expect_warning(etTrans(d, mod), "'rate'")

            d <- structure(list(ID = c(1L, 1L, 1L), TIME = c(0, 0, 0.25),
                                DV = c(0, 0.74, 2.84),
                                AMT = c(319.992, 0, 0), EVID = c(101L, 0L, 0L),
                                WT = c(79.6, 79.6, 79.6), DUR = c(-2, 0, 0)),
                           row.names = c(NA, 3L), class = "data.frame")

            expect_warning(etTrans(d, mod), "'dur'")

            d <- structure(list(ID = c(1L, 1L, 1L), TIME = c(0, 0, 0.25),
                                DV = c(0, 0.74, 2.84),
                                AMT = c(319.992, 0, 0), EVID = c(101L, 0L, 0L),
                                WT = c(79.6, 79.6, 79.6), SS = c(1, 0, 0),
                                II=c(24,0,0)),
                           row.names = c(NA, 3L), class = "data.frame")

            expect_warning(etTrans(d, mod),"'ss'")
        })

        context("DV=NA test, Issue #106")

        mod <- RxODE("    x1(0) = x10\n    d/dt(x1) = a * x1\n    Volume = x1;\ncmt(Volume);\n\n    nlmixr_pred <- Volume")

        test_that("DV=NA", {
            RawData2 <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                                   TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                                   DV = c( NA, 30, 80, 250, NA, 40, 150, 400 ))

            dat1 <- etTrans(RawData2, mod)

            RawData2a <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                                    TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                                    DV = c( NA, 30, 80, 250, NA, 40, 150, 400 ),
                                    AMT = c( NA, NA, NA, NA, NA, NA, NA, NA )
                                    )

            dat1a <- etTrans(RawData2a, mod)

            RawData2b <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                                    TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                                    DV = c( NA, 30, 80, 250, NA, 40, 150, 400 ),
                                    AMT = c( 0, 0, 0, 0, 0, 0, 0, 0 )
                                    )

            dat1b <- etTrans(RawData2b, mod)


            RawData2c <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                                    TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                                    DV = c( NA, 30, 80, 250, NA, 40, 150, 400 ),
                                    AMT = c( 1, 0, 0, 0, 1, 0, 0, 0 )
                                    )
            dat1c <- etTrans(RawData2c, mod)

            expect_equal(dat1a$EVID, c(2L, 0L, 0L, 0L, 2L, 0L, 0L, 0L))
            expect_equal(dat1a$EVID, dat1b$EVID)
            expect_equal(dat1c$EVID, c(101L, 0L, 0L, 0L, 101L, 0L, 0L, 0L))
        })

        RawData3 <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                               TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                               DV = c( 0, 30, 80, 250, 0, 40, 150, 400 ),
                               EVID = c( 2, 0, 0, 0, 2, 0, 0, 0 ))

        dat2 <- etTrans(RawData3, mod)

        RawData4 <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                               TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                               DV = c( 0, 30, 80, 250, 0, 40, 150, 400 ),
                               EVID = c( 2, 0, 0, 0, 2, 0, 0, 0 ),
                               CMT = c( 1, 0, 0, 0, 1, 0, 0, 0 ))

        dat3 <- etTrans(RawData4, mod)

        RawData5 <- data.frame( ID = c( 1, 1, 1, 1, 2, 2, 2, 2 ),
                               TIME = c( 0, 3, 4, 5, 0, 3, 4, 5 ),
                               DV = c( 0, 30, 80, 250, 0, 40, 150, 400 ),
                               EVID = c( 2, 0, 0, 0, 2, 0, 0, 0 ),
                               CMT = c( 2, 0, 0, 0, 2, 0, 0, 0 ))

        dat4 <- etTrans(RawData5, mod)

        test_that("dat2=dat4", {
            expect_equal(as.data.frame(dat2), as.data.frame(dat4))
        })

        test_that("dat3 has evid w/amt 0", {
            expect_equal(dat3$EVID, c(101L, 2L, 0L, 0L, 0L, 101L, 2L, 0L, 0L, 0L))
            expect_equal(dat3$AMT, c(0, NA, NA, NA, NA, 0, NA, NA, NA, NA))
        })

        context("X(0)=ini at zero or elsewhere (#105)")

        test_that("X(0) should be at time zero", {

            mod <- RxODE("    x1(0) = x10\n    d/dt(x1) = a * x1\n    Volume = x1;\ncmt(Volume);\n\n    nlmixr_pred <- Volume")

            rxSetIni0(FALSE)
            RawData2 <- data.frame( ID = c(  1, 1, 1, 2, 2, 2 ),
                                   TIME = c(  3, 4, 5, 3, 4, 5 ),
                                   DV = c(  30, 80, 250, 40, 150, 400 ))
            dat1 <- expect_warning(etTrans(RawData2, mod))

            expect_equal(dat1$TIME, RawData2$TIME)

            rxSetIni0(TRUE)
            dat1 <- etTrans(RawData2, mod)

            expect_equal(dat1$TIME, c(0, 3, 4, 5, 0, 3, 4, 5 ))
            expect_equal(dat1$EVID, c(9L, 0L, 0L, 0L, 9L, 0L, 0L, 0L))

        })

        rxSetIni0(TRUE)

        context("Constant infusion taken to steady state")
        test_that("RxODE constant infusion taken to steady state", {

            mod <- RxODE("
a = 6
b = 0.6
d/dt(intestine) = -a*intestine
d/dt(blood)     = a*intestine - b*blood
")

    trn1 <- etTrans(et(amt=0,rate=10,ss=1),mod,keepDosingOnly = TRUE) %>% as.data.frame
    expect_equal(structure(list(ID = structure(1L, class = "factor", .Label = "1"),
                                TIME = 0, EVID = 10140L, AMT = 10, II = 0, DV = NA_real_),
                           class = "data.frame", row.names = c(NA, -1L)), trn1)

    trn1 <- etTrans(et(amt=0,rate=-1,ss=1),mod,keepDosingOnly = TRUE) %>% as.data.frame

    expect_equal(structure(list(ID = structure(1L, class = "factor", .Label = "1"),
                                TIME = 0, EVID = 90140L, AMT = 0, II = 0, DV = NA_real_),
                           class = "data.frame", row.names = c(NA, -1L)), trn1)
})

        ## etTrans example from xgxr + nlmixr + ggpmx
        test_that("etTrans", {

            lst <- readRDS("test-etTrans-1.rds");

            t0 <- expect_warning(etTrans(lst$events,RxODE(lst$object), FALSE, FALSE, FALSE, FALSE, NULL, character(0)))
            expect_true(inherits(t0, "rxEtTran"))

            t1 <- etTrans(lst$events,RxODE(lst$object), FALSE, FALSE, FALSE, TRUE, NULL, character(0))
            expect_true(inherits(t1, "rxEtTran"))
        })

        test_that("etTrans drop levels are correct", {
            dat <- readRDS("etTrans-drop.rds")
            mod <- RxODE("ka=nlmixr_lincmt_ka;\ncl=nlmixr_lincmt_cl;\nv=nlmixr_lincmt_v;\nq=nlmixr_lincmt_q;\nvp=nlmixr_lincmt_vp;\nrx_ka~ka;\nrx_rate~0;\nrx_dur~0;\nrx_tlag~0;\nrx_tlag2~0;\nrx_F~1;\nrx_F2~1;\nrx_v~v;\nrx_k~cl/v;\nrx_k12~q/v;\nrx_k21~q/vp;\nrx_beta~0.5*(rx_k12+rx_k21+rx_k-sqrt((rx_k12+rx_k21+rx_k)*(rx_k12+rx_k21+rx_k)-4.0*rx_k21*rx_k));\nrx_alpha~rx_k21*rx_k/rx_beta;\nrx_A~rx_ka/(rx_ka-rx_alpha)*(rx_alpha-rx_k21)/(rx_alpha-rx_beta)/rx_v;\nrx_B~rx_ka/(rx_ka-rx_beta)*(rx_beta-rx_k21)/(rx_beta-rx_alpha)/rx_v;\nrx_A2~(rx_alpha-rx_k21)/(rx_alpha-rx_beta)/rx_v;\nrx_B2~(rx_beta-rx_k21)/(rx_beta-rx_alpha)/rx_v;\nrx_gamma~0;\nrx_C~0;\nrx_C2~0;\nnlmixr_lincmt_pred=solveLinB(rx__PTR__,t,0,rx_A,rx_A2,rx_alpha,rx_B,rx_B2,rx_beta,rx_C,rx_C2,rx_gamma,rx_ka,rx_tlag,rx_tlag2,rx_F,rx_F2,rx_rate,rx_dur);\n\n    nlmixr_pred <- nlmixr_lincmt_pred")
            tmp <- expect_warning(etTrans(dat, mod))
            lvls <- c("32", "33", "35", "36", "37", "40", "41", "42", "43", "47",
                      "48", "49", "50", "51", "54", "55", "57", "59", "61", "62", "63",
                      "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74",
                      "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85",
                      "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96",
                      "97", "98", "99", "100", "101", "102", "103", "104", "105", "106",
                      "107", "108", "109", "110", "111", "112", "113", "114", "115",
                      "116", "117", "118", "119", "120", "121", "122", "123", "124",
                      "125", "126", "127", "128", "129", "130", "131", "132", "133",
                      "134", "135", "136", "137", "138", "139", "140", "141", "142",
                      "143", "144", "145", "146", "147", "148", "149", "150", "151",
                      "152", "153", "154", "155", "156", "157", "158", "159", "160",
                      "161", "162", "163", "164", "165", "166", "167", "168", "169",
                      "170", "171", "172", "173", "174", "175", "176", "177", "178",
                      "179", "180")
            expect_equal(attr(class(tmp), ".RxODE.lst")$idLvl, lvls)
            expect_equal(levels(tmp$ID), lvls)
        })



    }

}, cran=TRUE, silent=TRUE)
