% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cvPost}
\alias{cvPost}
\title{Sample a covariance Matrix from the Posteior Inverse Wishart distribution.}
\usage{
cvPost(nu, omega, n = 1L, omegaIsChol = FALSE, returnChol = FALSE)
}
\arguments{
\item{nu}{Degrees of Freedom (Number of Observations) for 
covariance matrix simulation.}

\item{omega}{Estimate of Covariance matrix.}

\item{n}{Number of Matricies to sample.  By default this is 1.}

\item{omegaIsChol}{is an indicator of if the omega matrix is in the cholesky decomposition.}

\item{returnChol}{Return the cholesky decomposition of the covariance matrix sample.}
}
\value{
a matrix (n=1) or a list of matricies (n > 1)
}
\description{
Note this Inverse wishart rescaled to match the original scale of the covariance matrix.
}
\details{
If your covariance matrix is a 1x1 matrix, this uses an scaled inverse chi-squared which 
is equivalent to the Inverse Wishart distribution in the uni-directional case.
}
\author{
Matthew L.Fidler & Wenping Wang
}
