% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vcgUpdateNormals}
\alias{vcgUpdateNormals}
\title{updates vertex normals of a triangular meshes or point clouds}
\usage{
vcgUpdateNormals(mesh, type = 0, pointcloud = c(10, 0))
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d' or a n x 3 matrix containing 3D-coordinates.}

\item{type}{select the method to compute per-vertex normals: 0=area weighted average of surrounding face normals; 1 = angle weighted vertex normals.}

\item{pointcloud}{integer vector of length 2: containing optional parameters for normal calculation of point clouds. The first enty specifies the number of neighbouring points to consider. The second entry specifies the amount of smoothing iterations to be performed.}
}
\value{
mesh with updated/created normals, or in case \code{mesh} is a matrix, a list of class "mesh3d" with
\item{vb }{4 x n matrix containing coordinates (as homologous coordinates}
\item{normals }{4 x n matrix containing normals (as homologous coordinates}
}
\description{
update vertex normals of a triangular meshes or point clouds
}
\examples{
data(humface)
humface$normals <- NULL # remove normals
humface <- vcgUpdateNormals(humface)
\dontrun{
pointcloud <- t(humface$vb[1:3,]) #get vertex coordinates
pointcloud <- vcgUpdateNormals(pointcloud)

require(Morpho)
plotNormals(pointcloud)#plot normals
}
}

