\name{vcgQEdecim}
\alias{vcgQEdecim}
\title{Performs Quadric Edge Decimation on triangular meshes.}
\usage{
vcgQEdecim(mesh, tarface = NULL, percent = NULL, edgeLength = NULL,
  topo = TRUE, quality = TRUE, bound = TRUE, optiplace = TRUE,
  scaleindi = TRUE, normcheck = FALSE, safeheap = FALSE, qthresh = 0.1,
  boundweight = 0.5, normalthr = pi/2)
}
\arguments{
  \item{mesh}{Triangular mesh of class "mesh3d"}

  \item{tarface}{Integer: set number of target faces.}

  \item{percent}{Numeric: between 0 and 1. Set amount of
  reduction relative to existing face number. Overrides
  tarface argument.}

  \item{edgeLength}{Numeric: tries to decimate according to
  a target mean edge length. Under the assumption of
  regular triangles, the edges are half as long by dividing
  the triangle into 4 regular smaller triangles.}

  \item{topo}{logical: if TRUE, mesh topology is
  preserved.}

  \item{quality}{logical: if TRUE, vertex quality is
  considered.}

  \item{bound}{logical: if TRUE, mesh boundary is
  preserved.}

  \item{optiplace}{logical: if TRUE, mesh boundary is
  preserved.}

  \item{scaleindi}{logical: if TRUE, decimatiion is scale
  independent.}

  \item{normcheck}{logical: if TRUE, normal directions are
  considered.}

  \item{safeheap}{logical: if TRUE, safeheap update option
  enabled.}

  \item{qthresh}{numeric: Quality threshold for decimation
  process.}

  \item{boundweight}{numeric: Weight assigned to mesh
  boundaries.}

  \item{normalthr}{numeric: threshold for normal check in
  radians.}
}
\value{
  Returns a reduced mesh of class mesh3d.
}
\description{
  Decimates a mesh by adapting the faces of a mesh either
  to a target face number, a percentage or an approximate
  mesh resolution (a.k.a. mean edge length
}
\details{
  This is basically an adaption of the cli tridecimator
  from vcglib
}
\examples{
data(humface)
##reduce faces to 50\%
decimface <- vcgQEdecim(humface, percent=0.5, normcheck = TRUE)
## view
\dontrun{
require(rgl)
shade3d(decimface, col=3)

## some light smoothing
decimface <- vcgSmooth(decimface,iteration = 1)
}
}
\author{
  Stefan Schlager
}
\seealso{
  \code{\link{vcgSmooth}}
}
\keyword{~kwd1}
\keyword{~kwd2}

