% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgIsotropicRemeshing.r
\name{vcgIsotropicRemeshing}
\alias{vcgIsotropicRemeshing}
\title{Isotropically remesh a triangular surface mesh}
\usage{
vcgIsotropicRemeshing(
  x,
  TargetLen = 1,
  FeatureAngleDeg = 10,
  MaxSurfDist = 1,
  iterations = 3,
  Adaptive = FALSE,
  split = TRUE,
  collapse = TRUE,
  swap = TRUE,
  smooth = TRUE,
  project = TRUE,
  surfDistCheck = TRUE
)
}
\arguments{
\item{x}{mesh of class \code{mesh3d}}

\item{TargetLen}{numeric: edge length of the target surface}

\item{FeatureAngleDeg}{define Crease angle (in degree).}

\item{MaxSurfDist}{Max. surface distance}

\item{iterations}{ToDo}

\item{Adaptive}{enable adaptive remeshing}

\item{split}{enable refine step}

\item{collapse}{enable collapse step}

\item{swap}{enable dge swap}

\item{smooth}{enable smoothing}

\item{project}{enable reprojection step}

\item{surfDistCheck}{check distance to surface}
}
\value{
returns the remeshed surface mesh
}
\description{
Isotropically remesh a triangular surface mesh
}
\examples{
\dontrun{
data(humface)
resampledMesh <- vcgIsotropicRemeshing(humface,TargetLen=2.5)
}
}
