% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantile.R
\name{weighted.quant}
\alias{weighted.quant}
\title{Weighted quantile}
\usage{
weighted.quant(x, w = rep(1, length(x)), q = 0.5)
}
\arguments{
\item{x}{(numeric vector) Variable of interest for which to compute the quantile}

\item{w}{(numeric vector) Vector with the weights}

\item{q}{(numeric vector) A number between 0 and less than 1 indicating the desired quantile}
}
\value{
Scalar containing the quantile
}
\description{
Computes weighted quantiles of a numeric vector.
}
\examples{
weighted.quant(x = mtcars$mpg, w = mtcars$wt,  q = seq(.1,.9,.1))

}
