% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indep_diff.R
\name{indep_diff}
\alias{indep_diff}
\title{Independent Differences of columns}
\usage{
indep_diff(df, vec_series)
}
\arguments{
\item{df}{(dataframe) Dataframe that contains the columns with b. and se. on their name to get the difference from}

\item{vec_series}{(numeric vector) Column names to get difference from, not including "b." at the start. Must have a column in dataframe also including "se.".}
}
\value{
Dataframe with extra columns containing the difference of the columns along with their standard error.
}
\description{
Get in a dataframe all bivariate combinations of differences and standard errors from columns starting with b. and se. assuming independence.
For a time series the vector must be order from oldest to newest.
}
\examples{
indep_diff(rrepest_pisa_age_isced, paste0("mean.age..ISCED level ",c("1","3A","2")))

}
