# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Multivariate normal density
#' @description
#' Function to compute the density of a multivariate normal distribution.
#' @param x
#' A matrix, the arguments.
#' @param mean
#' A vector, the mean.
#' @param sigma
#' A matrix, the covariance matrix.
#' @param logd
#' A boolean, whether to apply the logarithm.
#' @return A vector, the computed multivariate normal densities
#' @export
#'
dmvnrm_arma_mc <- function(x, mean, sigma, logd = FALSE) {
    .Call(`_RprobitB_dmvnrm_arma_mc`, x, mean, sigma, logd)
}

#' Draw from Dirichlet
#' @description
#' Function to draw from a Dirichlet distribution.
#' @param alpha
#' A vector, the concentration parameter.
#' @return
#' A vector, the sample from the Dirichlet distribution.
#' @export
#'
rdirichlet <- function(alpha) {
    .Call(`_RprobitB_rdirichlet`, alpha)
}

#' Draw from a Wishart
#' @description
#' Function to draw from Wishart and inverted Wishart distribution.
#' @param nu
#' A double, the degrees of freedom.
#' @param V
#' A matrix, the scale matrix.
#' @return
#' A list, the draw from the Wishart (W), inverted Wishart (IW), and
#' corresponding Cholesky decomposition (C and CI)
#' @export
#'
rwishart <- function(nu, V) {
    .Call(`_RprobitB_rwishart`, nu, V)
}

#' Gibbs sampler.
#' @description
#' This function performs Gibbs sampling for the RprobitB package.
#' @inheritParams mcmc
#' @inheritParams RprobitB_data
#' @param sufficient_statistics
#' The output of \code{\link{compute_sufficient_statistics}}.
#' @param init
#' The output of \code{\link{set_initial_gibbs_values}}.
#' @return
#' A list of Gibbs samples for \code{Sigma}, \code{alpha} (if \code{P_f>0})
#' and \code{s}, \code{b}, \code{Omega} and a vector of classifications
#' (if \code{P_r>0}).
#' @keywords
#' internal
#'
gibbs_sampling <- function(R, B, print_progress, N, J, P_f, P_r, latent_classes, sufficient_statistics, prior, init) {
    .Call(`_RprobitB_gibbs_sampling`, R, B, print_progress, N, J, P_f, P_r, latent_classes, sufficient_statistics, prior, init)
}

