% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_sf_plot.R
\name{create_sf_plot}
\alias{create_sf_plot}
\title{create_sf_plot}
\usage{
create_sf_plot(
  sf,
  gg = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  aes_size = NULL,
  aes_text = NULL,
  text_size = 3,
  text_color = "black",
  text_fontface = "plain",
  text_check_overlap = FALSE,
  text_nudge_x = 0,
  text_nudge_y = 0,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  xlim = NULL,
  ylim = NULL,
  grid_line_color = NULL,
  grid_line_size = 1,
  panel_color = NULL,
  panel_border_color = "black",
  panel_expand = FALSE,
  sf_color = "black",
  sf_fill = "gray",
  sf_stroke = 0.1,
  sf_shape = 21,
  sf_size = 0.1,
  sf_linewidth = 0.1,
  sf_alpha = 1,
  inherit_aes = TRUE,
  na_rm = FALSE,
  scale_breaks = waiver(),
  scale_values = NULL,
  scale_limits = NULL,
  scale_labels = waiver(),
  scale_colors = heat.colors(8),
  scale_na_value = "gray50",
  own_scale = FALSE,
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.5,
  legend_key_height = 0.7,
  legend_key_backgrd = "white"
)
}
\arguments{
\item{sf}{A simple features object of class "sf".}

\item{gg}{A base ggplot2 object wherein this ggplot2's geom_sf object is layered on.}

\item{aes_color}{The variable name from 'sf' for the dependent aesthetic mapping for color.}

\item{aes_fill}{The variable name from 'sf' for the dependent aesthetic mapping for fill.
If the variable is a discrete factor, see ggplot2::scale_fill_manual() for appropriate scaling values.
If the variable is continuous, see ggplot2::scale_fill_gradientn().}

\item{aes_size}{The variable name from 'sf' for the dependent aesthetic mapping for point size.}

\item{aes_text}{The variable name from 'sf' for the dependent aesthetic mapping for text labeling.}

\item{text_size}{A numeric value that sets the size of aesthetic mapping of text (i.e. aes_text)}

\item{text_color}{A string that sets the color of aesthetic mapping of text color (i.e. aes_text)}

\item{text_fontface}{A string that sets the fontface of aesthetic mapping of text fontface (i.e. aes_text).
Acceptable values: "plain", "bold", "italic", "bold.italic". The default is "plain".}

\item{text_check_overlap}{A logical which if TRUE will not plot text that overlaps.}

\item{text_nudge_x}{A numeric that sets the value for nudging the text in the x direction.}

\item{text_nudge_y}{A numeric that sets the value for nudging the text in the y direction.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default)  then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default)  then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{xlim}{A numeric vector pair of longitudinal values for zooming in/out the mapping}

\item{ylim}{A numeric vector pair of latitudinal values for zooming in/out the mapping}

\item{grid_line_color}{A string in hexidecimal or color name that sets the plot major grid line color.
The default is NULL and takes on ggplot2's default white.}

\item{grid_line_size}{A numeric that sets the grid line's width. The default is 1.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is NULL and takes on ggplot2's default gray..}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black". Set it to \code{NA} to eliminate the border rectangle entirely.}

\item{panel_expand}{A logical which if TRUE, expands the plot panel and potentially hides the tics.
The default is \code{FALSE}.}

\item{sf_color}{A string that sets the color attribute of the sf.}

\item{sf_fill}{A string that sets the fill color attribute of the sf.}

\item{sf_stroke}{A numeric that sets the drawing stroke width attribute for a sf point geometry.}

\item{sf_shape}{A numeric that sets the non-variable associated shape aesthetic.}

\item{sf_size}{A numeric value that sets the size attribute for scaling points.}

\item{sf_linewidth}{A numeric value that sets the line width of POLYGON, LINESTRING geometries.}

\item{sf_alpha}{A numeric value that sets the alpha level attribute of point and line geometries..}

\item{inherit_aes}{A logical which if \code{FALSE} the aesthetics are not combined with other overlapping geoms.}

\item{na_rm}{A logical which if \code{TRUE}, missing observations are removed. If FALSE, the default,
missing observations are removed with a warning.}

\item{scale_breaks}{A string/numeric vector that defines the scale breaks.}

\item{scale_values}{A string/numeric vector that defines the possible values.}

\item{scale_limits}{A string/numeric vector that defines the scale limits.}

\item{scale_labels}{An optional string vector that defines the scale labels. Vector must be the same length
as 'scale_breaks'.}

\item{scale_colors}{Vector of colors to use for n-color gradient.}

\item{scale_na_value}{A string that sets the color for missing values.}

\item{own_scale}{A logical which if TRUE, then your own scaling may be appended to the plot without using the above
scale_* parameters.}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}
}
\value{
A ggplot class object.
}
\description{
The function is a wrapper around \code{ggplot2::geom_sf()} that plots simple feature objects.
See \href{https://r-spatial.github.io/sf/articles/sf1.html}{Simple Features for R}
  for more information on simple features.

For a good introduction to using ggplot2::geom_sf
  see \href{https://r-spatial.org/r/2018/10/25/ggplot2-sf.html}{Drawing beautiful maps programmatically with R, sf and ggplot2}.

The function accepts objects of class sf for visualizing their points, lines, and polygon geometries. Easy plotting is
  possible with the function's parameters for scaling, color, size, variable aesthetic mapping, and text labeling. Overlapping
  of geometries is possible by chaining multiple functions via standard piping.
}
\examples{
library(ggplot2)
library(RColorBrewer)
library(RplotterPkg)

# map country coffee production over country geometries
RplotterPkg::create_sf_plot(
  sf = spData::world,
  title = "World Coffee Production 2017",
  subtitle = "Source: spData::coffee_data",
  panel_color = "white",
  panel_border_color = "white",
) |>
  RplotterPkg::create_sf_plot(
    sf = RplotterPkg::world_coffee,
    aes_fill = "coffee_production_2017",
    scale_breaks = seq(0,3000,250),
    scale_labels = seq(0,3000,250),
    scale_limits = c(0,3000),
    scale_colors = RColorBrewer::brewer.pal(n = 9, name = "YlOrRd"),
    legend_key_width = 0.7,
    legend_key_height = 1.0
  )

}
