% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.remote.R
\name{files.remote}
\alias{files.remote}
\title{Create a remote file and link it to an item}
\usage{
files.remote(file_type, title, item_type, item_id, remote_location,
  api_token = NULL, company_domain = "api",
  return_type = c("complete", "boolean"))
}
\arguments{
\item{file_type}{The file type. This field has the following domains: (gdoc; gslides; gsheet; gform; gdraw)}

\item{title}{The title of the file.}

\item{item_type}{The item type. This field has the following domains: (deal; organization; person)}

\item{item_id}{ID of the item to associate the file with.}

\item{remote_location}{The location type to send the file to. Only googledrive is supported at the moment. This field has the following domains: (googledrive)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Create a remote file and link it to an item on pipedrive.
}
\examples{
\donttest{
files.remote(file_type='e.g.',title='e.g.',item_type='e.g.',item_id='e.g.',remote_location='e.g.')
}
}
