% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RuleInduction.R
\name{RI.laplace}
\alias{RI.laplace}
\alias{RI.support}
\alias{RI.confidence}
\alias{RI.lift}
\title{Quality indicators of RST decision rules}
\usage{
RI.laplace(rules, ...)
RI.support(rules, ...)
RI.confidence(rules, ...)
RI.lift(rules, ...)
}
\arguments{
\item{rules}{a \code{"RuleSetRST"} object containing a set of decision rules. See \code{\link{RI.LEM2Rules.RST}}.}

\item{...}{the other parameters (currently omitted).}
}
\value{
A numeric vector with values of the corresponding quality measure.
}
\description{
Functions for extracting quality indices of rules.
}
\examples{
###########################################################
## Example : Filtering a set of decision rules
###########################################################
data(RoughSetData)
hiring.data <- RoughSetData$hiring.dt

rules <- RI.LEM2Rules.RST(hiring.data)

rules

# a vector of rules' Laplace estimate of the confidence:
RI.laplace(rules)
# a vector of rules' confidence values:
RI.confidence(rules)

# subsetting a set of rules:
rules[RI.support(rules) > 0.2]
rules[RI.lift(rules) < 1.5]

}
\author{
Andrzej Janusz
}
