\name{SF.read.DecisionTable}
\alias{SF.read.DecisionTable}
\title{The importing function}
\usage{
SF.read.DecisionTable(filename, decision.attr = NULL, indx.nominal = NULL,
  ...)
}
\arguments{
  \item{filename}{a file name that contains objects/data.
  See also \code{\link{read.table}}.}

  \item{decision.attr}{a index position of decision
  attribute. See \code{\link{SF.asDecisionTable}}.}

  \item{indx.nominal}{a indexes of nominal values. See
  \code{\link{SF.asDecisionTable}}.}

  \item{...}{other parameters which are involved in
  \code{read.table} function. See \code{\link{read.table}}.
  An important parameter in \code{\link{read.table}} that
  should be taken into account is \code{col.names}.}
}
\value{
A \code{"DecisionTable"} class which is the standard
decision table. See \code{\link{SF.asDecisionTable}}.
}
\description{
It is a additional function used to import dataset from
files and then construct them into the standard decision
table.
}
\details{
It is used to read a dataset from files with the following
format: ".csv", ".txt", ".dat", and ".xls", into decision
table format. The data should be in table format containing
rows and columns without header, where every row represents
every object/instance while columns represent attributes of
the objects.

The output of this function is a decision table which
fulfills a standard format of RoughSets package (See
\code{\link{SF.asDecisionTable}}).
}
\examples{
#############################################################
## Example 1: dataset saved in a file
#############################################################
## Let us assume we have the following data which has been already saved to the file "tes.dat"
data <- data.frame(c(0.12, 0.23, 0.24), c(1,3,2), c(10, 12, 18), c("a", "a", "b"), c(1, 1, 2))
\dontrun{write.table(data, file = "tes.dat", row.names = FALSE, col.names = FALSE,
                    fileEncoding ="")}

## Then we would generate decision table from tes.dat file.
## in this case, we want to define that second and third attributes are nominal and continuous,
## respectively.
\dontrun{decision.table <- SF.read.DecisionTable(filename = "tes.dat", decision.attr = 5,
                  indx.nominal = c(2, 5), sep= " ", col.names = c("v1", "v2", "v3", "v4", "o1"))}
}

