% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSHT.R
\name{TSHT}
\alias{TSHT}
\title{Two-Stage Hard Thresholding}
\usage{
TSHT(
  Y,
  D,
  Z,
  X,
  intercept = TRUE,
  method = c("OLS", "DeLasso", "Fast.DeLasso"),
  voting = c("MaxClique", "MP", "Conservative"),
  robust = FALSE,
  alpha = 0.05,
  tuning.1st = NULL,
  tuning.2nd = NULL
)
}
\arguments{
\item{Y}{The outcome observation, a vector of length \eqn{n}.}

\item{D}{The treatment observation, a vector of length \eqn{n}.}

\item{Z}{The instrument observation of dimension \eqn{n \times p_z}.}

\item{X}{The covariates observation of dimension \eqn{n \times p_x}.}

\item{intercept}{Whether the intercept is included. (default = \code{TRUE})}

\item{method}{The method used to estimate the reduced form parameters. \code{"OLS"} stands for ordinary least squares, \code{"DeLasso"} stands for the debiased Lasso estimator, and \code{"Fast.DeLasso"} stands for the debiased Lasso estimator with fast algorithm. (default = \code{"OLS"})}

\item{voting}{The voting option used to estimate valid IVs. \code{'MP'} stands for majority and plurality voting, \code{'MaxClique'} stands for finding maximal clique in the IV voting matrix, and \code{'Conservative'} stands for conservative voting procedure. Conservative voting is used to get an initial estimator of valid IVs in the Searching-Sampling method. (default= \code{'MaxClique'}).}

\item{robust}{If \code{TRUE}, the method is robust to heteroskedastic errors. If \code{FALSE}, the method assumes homoskedastic errors. (default = \code{FALSE})}

\item{alpha}{The significance level for the confidence interval. (default = \code{0.05})}

\item{tuning.1st}{The tuning parameter used in the 1st stage to select relevant instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}

\item{tuning.2nd}{The tuning parameter used in the 2nd stage to select valid instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}
}
\value{
\code{TSHT} returns an object of class "TSHT", which is a list containing the following components:
    \item{\code{betaHat}}{The estimate of treatment effect.}
    \item{\code{beta.sdHat}}{The estimated standard error of \code{betaHat}.}
    \item{\code{ci}}{The 1-alpha confidence interval for \code{beta}.}
    \item{\code{SHat}}{The set of selected relevant IVs.}
    \item{\code{VHat}}{The set of selected relevant and valid IVs.}
    \item{\code{voting.mat}}{The voting matrix.}
    \item{\code{check}}{The indicator that the majority rule is satisfied.}
}
\description{
Perform Two-Stage Hard Thresholding method, which provides the robust inference of the treatment effect in the presence of invalid instrumental variables.
}
\details{
When \code{robust = TRUE}, the \code{method} will be input as \code{’OLS’}.
When \code{voting = MaxClique} and there are multiple maximum cliques, \code{betaHat},\code{beta.sdHat},\code{ci}, and \code{VHat} will be list objects
where each element of list corresponds to each maximum clique.
As for tuning parameter in the 1st stage and 2nd stage, if do not specify, for method "OLS" we adopt \eqn{\sqrt{\log n}} for both tuning parameters, and for other methods
we adopt \eqn{\max{(\sqrt{2.01 \log p_z}, \sqrt{\log n})}} for both tuning parameters.
}
\examples{
data("lineardata")
Y <- lineardata[,"Y"]
D <- lineardata[,"D"]
Z <- as.matrix(lineardata[,c("Z.1","Z.2","Z.3","Z.4","Z.5","Z.6","Z.7","Z.8")])
X <- as.matrix(lineardata[,c("age","sex")])
TSHT.model <- TSHT(Y=Y,D=D,Z=Z,X=X)
summary(TSHT.model)

}
\references{
{
Guo, Z., Kang, H., Tony Cai, T. and Small, D.S. (2018), Confidence intervals for causal effects with invalid instruments by using two-stage hard thresholding with voting, \emph{J. R. Stat. Soc. B}, 80: 793-815. \cr
}
}
